<div class="row">
    @foreach ($empresas as $empresa)
        <div class="col-md-6 mb-4">
            <div class="card project-card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        @if(!empty($empresa->sitio_web))
                            <a href="{{ $empresa->sitio_web }}" target="_blank" rel="noopener">
                                {{ $empresa->nombre_comercial ?? $empresa->razon_social }}
                            </a>
                        @else
                            {{ $empresa->nombre_comercial ?? $empresa->razon_social }}
                        @endif
                    </h5>
                    <div class="d-flex align-items-center">
                        {{-- Badge de Estado de Empresa --}}
                        @php
                            $estadoClasses = [
                                'aprobada' => 'success',
                                'pendiente' => 'warning',
                                'rechazada' => 'danger',
                                'inactiva' => 'secondary',
                                'retirada' => 'dark',
                            ];
                            $estadoClass = $estadoClasses[$empresa->estado] ?? 'secondary';

                            $estadoLabels = [
                                'aprobada' => 'Vigente',
                                'inactiva' => 'Inactiva',
                                'retirada' => 'Retirada',
                            ];
                            $estadoLabel = $estadoLabels[$empresa->estado] ?? ucfirst($empresa->estado);
                        @endphp

                        @if(auth()->user()->hasRole('administrador') || auth()->user()->hasRole('proveedor'))
                            <a href="#" class="badge badge-{{ $estadoClass }} mr-1" 
                               data-toggle="modal" 
                               data-target="#changeStatusModal"
                               data-id="{{ $empresa->id }}"
                               data-estado="{{ $empresa->estado }}"
                               data-nombre="{{ $empresa->razon_social }}"
                               title="Cambiar estado"
                               style="cursor: pointer; text-decoration: none;">
                                {{ $estadoLabel }} <i class="fas fa-edit ml-1 small"></i>
                            </a>
                        @else
                            <span class="badge badge-{{ $estadoClass }} mr-1">{{ $estadoLabel }}</span>
                        @endif

                        @if ($empresa->estado == 'aprobada')
                            @php
                                $tareasPendientes = $empresa->tareas->where('estado', '!=', 'finalizado')->count();
                            @endphp
                            @if ($tareasPendientes > 0)
                                <span class="badge badge-danger" style="cursor: pointer;" onclick="showEmpresaTareas({{ $empresa->id }}, 'no_finalizado')" title="Ver tareas pendientes">{{ $tareasPendientes }} Tareas</span>
                            @endif
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <p class="card-text">
                        <small class="text-muted">Razón Social:</small><br>
                        <strong>{{ $empresa->razon_social }}</strong>
                    </p>
                    <div class="row">
                        <div class="col-sm-6">
                            <small class="text-muted">RUC:</small><br>
                            <strong>{{ $empresa->ruc }}</strong>
                            <span class="badge badge-secondary ml-2">Serie: {{ $empresa->serie ?? '-' }}</span>
                        </div>
                        <div class="col-sm-6">
                            <small class="text-muted">Responsables:</small><br>
                            @if($empresa->proveedores->count() > 0)
                                <ul class="list-unstyled mb-0">
                                    @foreach($empresa->proveedores as $proveedor)
                                        <li><strong>{{ $proveedor->nombre_corto }}</strong></li>
                                    @endforeach
                                </ul>
                            @else
                                <strong>Sin asignar</strong>
                            @endif
                        </div>
                    </div>
                    
                    @if($empresa->otrosRucs && $empresa->otrosRucs->count() > 0)
                        <div class="mt-2">
                            <small class="text-muted">Otros RUC:</small>
                            <ul class="list-unstyled mb-0">
                                @foreach($empresa->otrosRucs as $extra)
                                    <li>
                                        <strong>{{ $extra->ruc }}</strong>
                                        <span class="badge badge-light ml-2">Serie: {{ $extra->serie ?? '-' }}</span>
                                        <span class="text-muted ml-2">{{ $extra->razon_social }}</span>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                </div>
                <div class="card-footer">
                    <small class="text-muted">{{ $empresa->tareas->count() }} tareas</small>
                    <div class="float-right">
                        @if($empresa->estado != 'retirada')
                            <button type="button" class="btn btn-sm btn-outline-primary" data-toggle="tooltip" title="Ver" aria-label="Ver"
                                onclick="showEmpresaDetails({{ $empresa->id }})"><i class="fas fa-eye"></i></button>
                            @can('update', $empresa)
                                <button type="button" class="btn btn-sm btn-outline-secondary" data-toggle="modal" title="Editar" aria-label="Editar" data-toggle="tooltip"
                                    data-target="#editEmpresaModal" data-id="{{ $empresa->id }}"
                                    data-ruc="{{ $empresa->ruc }}" data-razon-social="{{ $empresa->razon_social }}"
                                    data-nombre-comercial="{{ $empresa->nombre_comercial }}"
                                    data-serie="{{ $empresa->serie }}"
                                    data-modo-pago="{{ $empresa->modo_pago }}"
                                    data-sitio-web="{{ $empresa->sitio_web }}"
                                    data-estado="{{ $empresa->estado }}"
                                    @unless(auth()->user()->hasRole('operador'))
                                        data-usuario-sol="{{ $empresa->usuario_sol }}" data-clave-sol="{{ $empresa->clave_sol }}"
                                        data-usuario-secundario-dni="{{ $empresa->usuario_secundario_dni }}"
                                        data-usuario-secundario-user="{{ $empresa->usuario_secundario_user }}"
                                        data-usuario-secundario-clave="{{ $empresa->usuario_secundario_clave }}"
                                        data-clave-certificado="{{ $empresa->clave_certificado }}"
                                    @endunless
                                    data-proveedores="{{ $empresa->proveedores->pluck('id') }}"
                                    data-descripcion="{{ $empresa->descripcion }}"
                                    data-fecha-solicitud="{{ $empresa->fecha_solicitud->format('Y-m-d') }}"><i class="fas fa-edit"></i></button>
                                <button type="button" class="btn btn-sm btn-outline-info ml-1" data-toggle="tooltip" title="Agregar RUC" aria-label="Agregar RUC"
                                    onclick="showRucsModal({{ $empresa->id }})"><i class="fas fa-id-card"></i></button>
                            @endcan
                            @if ($empresa->estado == 'aprobada')
                                @can('addProjects', $empresa)
                                    <!-- Button hidden as per user request -->
                                    <button type="button" class="btn btn-sm btn-outline-success d-none" data-toggle="tooltip" title="Agregar Tareas" aria-label="Agregar Tareas"
                                        onclick="openAddTareasModal({{ $empresa->id }}, '{{ $empresa->razon_social }}', {{ $empresa->tareas->max('orden') ?? 0 }})"><i class="fas fa-tasks"></i></button>
                                    <button type="button" class="btn btn-sm btn-outline-info ml-1" data-toggle="tooltip" title="Ver Tareas" aria-label="Ver Tareas"
                                        onclick="showEmpresaTareas({{ $empresa->id }})"><i class="fas fa-list-ul"></i></button>
                                @endcan
                            @endif
                        @endif
                        @can('delete', $empresa)
                            <button type="button" class="btn btn-sm btn-outline-danger" data-toggle="tooltip" title="Eliminar" aria-label="Eliminar"
                                onclick="confirmDeleteEmpresa({{ $empresa->id }}, '{{ addslashes($empresa->razon_social) }}')"><i class="fas fa-trash"></i></button>
                        @endcan
                    </div>
                </div>
            </div>
        </div>
    @endforeach
</div>

<div class="d-flex justify-content-between align-items-center mt-3">
    <div class="text-muted">
        Mostrando {{ $empresas->firstItem() ?? 0 }} a {{ $empresas->lastItem() ?? 0 }} de {{ $empresas->total() }} empresas
    </div>
    <div>
        {{ $empresas->links() }}
    </div>
</div>
