<table class="table table-striped table-hover">
    <thead class="thead-dark">
        <tr>
            <th>
                <a href="javascript:void(0)" class="text-white sort-link" data-sort="ruc">
                    RUC
                    @if($sortBy == 'ruc')
                        <i class="fas fa-sort-{{ $sortOrder == 'asc' ? 'up' : 'down' }}"></i>
                    @else
                        <i class="fas fa-sort text-muted"></i>
                    @endif
                </a>
            </th>
            <th>
                <a href="javascript:void(0)" class="text-white sort-link" data-sort="razon_social">
                    Razón Social
                    @if($sortBy == 'razon_social')
                        <i class="fas fa-sort-{{ $sortOrder == 'asc' ? 'up' : 'down' }}"></i>
                    @else
                        <i class="fas fa-sort text-muted"></i>
                    @endif
                </a>
            </th>
            <th>
                <a href="javascript:void(0)" class="text-white sort-link" data-sort="nombre_comercial">
                    Nombre Comercial
                    @if($sortBy == 'nombre_comercial')
                        <i class="fas fa-sort-{{ $sortOrder == 'asc' ? 'up' : 'down' }}"></i>
                    @else
                        <i class="fas fa-sort text-muted"></i>
                    @endif
                </a>
            </th>
            <th>Acciones</th>
        </tr>
    </thead>
    <tbody>
        @forelse ($empresas as $empresa)
            <tr>
                <td>{{ $empresa->ruc }}</td>
                <td>{{ $empresa->razon_social }}</td>
                <td>{{ $empresa->nombre_comercial ?? '-' }}</td>
                <td>
                    <button type="button" class="btn btn-info btn-sm" onclick="verCredenciales('{{ $empresa->ruc }}')">
                        <i class="fas fa-key"></i> Ver Credenciales
                    </button>
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="4" class="text-center">No se encontraron empresas.</td>
            </tr>
        @endforelse
    </tbody>
</table>

<div class="d-flex justify-content-center">
    {{ $empresas->withQueryString()->links() }}
</div>
