<div class="modal-header">
    <h5 class="modal-title">Agregar Nueva Tarea</h5>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>

<div class="modal-body">
    <form id="addTaskForm" action="{{ route('empresas.store-tareas', $empresa) }}" method="POST">
        @csrf
        
        <!-- Hidden index for array structure required by controller -->
        
        <div class="row">
            <div class="col-md-12 form-group">
                <label>Título de la Tarea <span class="text-danger">*</span></label>
                <input type="text" name="tareas[0][titulo]" class="form-control" required placeholder="Ej: Corregir error en login">
            </div>
            
            <div class="col-md-12 form-group">
                <label>Descripción <span class="text-danger">*</span></label>
                <textarea name="tareas[0][descripcion]" class="form-control" rows="3" required placeholder="Detalles de la tarea..."></textarea>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 form-group">
                <label>Fecha Inicio Est. <span class="text-danger">*</span></label>
                <input type="date" name="tareas[0][fecha_inicio_estimada]" class="form-control" value="{{ date('Y-m-d') }}" required>
            </div>
            <div class="col-md-6 form-group">
                <label>Fecha Fin Est. <span class="text-danger">*</span></label>
                <input type="date" name="tareas[0][fecha_fin_estimada]" class="form-control" value="{{ date('Y-m-d') }}" required>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 form-group">
                <label>Prioridad <span class="text-danger">*</span></label>
                <select name="tareas[0][prioridad]" class="form-control" required>
                    <option value="baja">Baja</option>
                    <option value="media" selected>Media</option>
                    <option value="alta">Alta</option>
                    <option value="urgente">Urgente</option>
                </select>
            </div>
            <div class="col-md-6 form-group">
                <label>Asignar Operador <span class="text-danger">*</span></label>
                <select name="tareas[0][operador_id]" class="form-control" required>
                    <option value="">Seleccione...</option>
                    @foreach($operadores as $operador)
                        <option value="{{ $operador->id }}">{{ $operador->nombre_completo }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="text-right">
            <button type="button" class="btn btn-secondary" onclick="showEmpresaTareas({{ $empresa->id }})">Cancelar</button>
            <button type="submit" class="btn btn-success">
                <i class="fas fa-plus-circle"></i> Guardar Tarea
            </button>
        </div>
    </form>
</div>
