<!-- resources/views/series/index.blade.php -->
@extends('layouts.app')

@section('content')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Empresas</h1>
        @can('create', App\Models\Empresa::class)
            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#createEmpresaModal">
                <i class="fas fa-plus"></i> Nueva Empresa
            </button>
        @endcan
    </div>

    <div class="row mb-3">
        <div class="col-md-6">
            <form action="{{ route('empresas.index') }}" method="GET" class="d-flex">
                <input type="text" name="search" class="form-control mr-2"
                    placeholder="Buscar por RUC, Razón Social o Nombre Comercial" value="{{ request('search') }}">
                <button type="submit" class="btn btn-outline-primary">Buscar</button>
                @if (request('search'))
                    <a href="{{ route('empresas.index') }}" class="btn btn-outline-secondary ml-2">Limpiar</a>
                @endif
            </form>
        </div>
    </div>

    <div id="empresas-container">
        @include('empresas.partials.list')
    </div>

    <!-- Modal Crear Empresa -->
    <div class="modal fade" id="createEmpresaModal" tabindex="-1" role="dialog" aria-labelledby="createEmpresaModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="createEmpresaModalLabel">Crear Nueva Empresa</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="POST" action="{{ route('empresas.store') }}">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="card">
                                    <div class="card-header">
                                        <h5>Información de la Empresa</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="ruc">RUC</label>
                                                    <input type="text" class="form-control @error('ruc') is-invalid @enderror"
                                                        id="ruc" name="ruc" value="{{ old('ruc') }}" required
                                                        maxlength="11">
                                                    @error('ruc')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="razon_social">Razón Social</label>
                                                    <input type="text"
                                                        class="form-control text-uppercase @error('razon_social') is-invalid @enderror"
                                                        id="razon_social" name="razon_social"
                                                        value="{{ old('razon_social') }}" required
                                                        oninput="this.value = this.value.toUpperCase()">
                                                    @error('razon_social')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="serie">Serie (3 dígitos)</label>
                                                    <input type="text" class="form-control @error('serie') is-invalid @enderror" id="serie"
                                                        name="serie" value="{{ old('serie') }}" maxlength="3" placeholder="001">
                                                    @error('serie')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="modo_pago">Modo de Pago</label>
                                                    <select class="form-control @error('modo_pago') is-invalid @enderror" id="modo_pago" name="modo_pago" required>
                                                        <option value="gratuito" {{ old('modo_pago', 'gratuito') == 'gratuito' ? 'selected' : '' }}>Gratuito (No paga)</option>
                                                        <option value="mensual" {{ old('modo_pago') == 'mensual' ? 'selected' : '' }}>Mensual</option>
                                                        <option value="anual" {{ old('modo_pago') == 'anual' ? 'selected' : '' }}>Anual</option>
                                                    </select>
                                                    @error('modo_pago')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-5">
                                                <div class="form-group">
                                                    <label for="nombre_comercial">Nombre Comercial (Opcional)</label>
                                                    <input type="text"
                                                        class="form-control text-uppercase @error('nombre_comercial') is-invalid @enderror"
                                                        id="nombre_comercial" name="nombre_comercial"
                                                        value="{{ old('nombre_comercial') }}"
                                                        oninput="this.value = this.value.toUpperCase()">
                                                    @error('nombre_comercial')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="sitio_web">Sitio Web (URL)</label>
                                            <input type="url" class="form-control @error('sitio_web') is-invalid @enderror" id="sitio_web"
                                                name="sitio_web" value="{{ old('sitio_web') }}" placeholder="https://www.ejemplo.com">
                                            @error('sitio_web')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="row">
                                            @unless(auth()->user()->hasRole('operador'))
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="usuario_sol">Usuario SOL (Opcional)</label>
                                                    <input type="text"
                                                        class="form-control @error('usuario_sol') is-invalid @enderror"
                                                        id="usuario_sol" name="usuario_sol"
                                                        value="{{ old('usuario_sol') }}">
                                                    @error('usuario_sol')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="clave_sol">Clave SOL (Opcional)</label>
                                                    <input type="text"
                                                        class="form-control @error('clave_sol') is-invalid @enderror"
                                                        id="clave_sol" name="clave_sol"
                                                        value="{{ old('clave_sol') }}">
                                                    @error('clave_sol')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            @endunless
                                        </div>

                                        <div class="form-group">
                                            <label for="descripcion">Descripción</label>
                                            <textarea class="form-control text-uppercase @error('descripcion') is-invalid @enderror" id="descripcion"
                                                name="descripcion" rows="3" oninput="this.value = this.value.toUpperCase()">{{ old('descripcion') }}</textarea>
                                            @error('descripcion')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        @unless(auth()->user()->hasRole('operador'))
                                        <h6 class="mt-3">Usuario Secundario</h6>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="usuario_secundario_dni">DNI</label>
                                                    <input type="text" class="form-control @error('usuario_secundario_dni') is-invalid @enderror" id="usuario_secundario_dni"
                                                        name="usuario_secundario_dni" value="{{ old('usuario_secundario_dni') }}" maxlength="8">
                                                    @error('usuario_secundario_dni')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="usuario_secundario_user">Usuario</label>
                                                    <input type="text" class="form-control @error('usuario_secundario_user') is-invalid @enderror" id="usuario_secundario_user"
                                                        name="usuario_secundario_user" value="{{ old('usuario_secundario_user') }}">
                                                    @error('usuario_secundario_user')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="usuario_secundario_clave">Clave</label>
                                                    <input type="text" class="form-control @error('usuario_secundario_clave') is-invalid @enderror" id="usuario_secundario_clave"
                                                        name="usuario_secundario_clave" value="{{ old('usuario_secundario_clave') }}">
                                                    @error('usuario_secundario_clave')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="clave_certificado">Clave del Certificado</label>
                                            <input type="text" class="form-control @error('clave_certificado') is-invalid @enderror" id="clave_certificado"
                                                name="clave_certificado" value="{{ old('clave_certificado') }}">
                                            @error('clave_certificado')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        @endunless

                                        

                                        @if(auth()->user()->hasRole('administrador'))
                                            <div class="form-group mt-3">
                                                <label class="font-weight-bold">Asignar Responsables</label>
                                                <div class="card bg-light">
                                                    <div class="card-body" style="max-height: 200px; overflow-y: auto;">
                                                        @foreach($proveedores as $proveedor)
                                                            <div class="custom-control custom-checkbox mb-2">
                                                                <input type="checkbox" name="proveedores[]" 
                                                                    class="custom-control-input" 
                                                                    id="modal_proveedor_{{ $proveedor->id }}" 
                                                                    value="{{ $proveedor->id }}">
                                                                <label class="custom-control-label" for="modal_proveedor_{{ $proveedor->id }}">
                                                                    {{ $proveedor->nombre_corto }}
                                                                </label>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                                <small class="text-muted">Seleccione los responsables que tendrán acceso a esta empresa.</small>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="card">
                                    <div class="card-header">
                                        <h5>Operadores Disponibles</h5>
                                    </div>
                                    <div class="card-body">
                                        @foreach ($operadores as $operador)
                                            <div class="mb-2">
                                                <strong>{{ $operador->nombre_completo }}</strong><br>
                                                <small class="text-muted">DNI: {{ $operador->dni }}</small>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card mt-4">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h5>Tareas de la Empresa</h5>
                                <button type="button" class="btn btn-sm btn-success" id="agregarTarea">
                                    <i class="fas fa-plus"></i> Agregar Tarea
                                </button>
                            </div>
                            <div class="card-body">
                                <div id="tareas-container">
                                    <!-- Las tareas se agregan dinámicamente aquí -->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Crear Empresa</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Modal Ver Empresa -->
    <div class="modal fade" id="showEmpresaModal" tabindex="-1" role="dialog" aria-labelledby="showEmpresaModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content" id="showEmpresaModalContent">
                <div class="modal-header">
                    <h5 class="modal-title" id="showEmpresaModalLabel">Detalles de la Empresa</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" id="showEmpresaModalBody">
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary" role="status">
                            <span class="sr-only">Cargando...</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Cambiar Estado -->
    <div class="modal fade" id="changeStatusModal" tabindex="-1" role="dialog" aria-labelledby="changeStatusModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="changeStatusModalLabel">Cambiar Estado de Empresa</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="changeStatusForm" method="POST">
                    @csrf
                    @method('PATCH')
                    <div class="modal-body">
                        <p>Empresa: <strong id="statusEmpresaName"></strong></p>
                        <div class="form-group">
                            <label for="new_estado">Nuevo Estado</label>
                            <select class="form-control" id="new_estado" name="estado" required>
                                <option value="pendiente">Pendiente</option>
                                <option value="aprobada">Aprobada (Vigente)</option>
                                <option value="rechazada">Rechazada</option>
                                <option value="inactiva">Inactiva (No Vigente)</option>
                                <option value="retirada">Retirada</option>
                            </select>
                        </div>
                        <div class="alert alert-info">
                            <small><i class="fas fa-info-circle"></i> Cambiar el estado afectará la visibilidad de la empresa en los reportes y asignaciones.</small>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Guardar Cambios</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Editar Empresa -->
    <div class="modal fade" id="editEmpresaModal" tabindex="-1" role="dialog" aria-labelledby="editEmpresaModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editEmpresaModalLabel">Editar Empresa</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="POST" action="" id="editEmpresaForm">
                    @csrf
                    @method('PATCH')
                    <div class="modal-body">
                        <div class="card">
                            <div class="card-header">
                                <h5>Información de la Empresa</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="edit_ruc">RUC</label>
                                            <input type="text" class="form-control @error('ruc') is-invalid @enderror"
                                                id="edit_ruc" name="ruc" value="{{ old('ruc') }}" required
                                                maxlength="11">
                                            @error('ruc')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="edit_razon_social">Razón Social</label>
                                            <input type="text"
                                                class="form-control text-uppercase @error('razon_social') is-invalid @enderror"
                                                id="edit_razon_social" name="razon_social"
                                                value="{{ old('razon_social') }}" required
                                                oninput="this.value = this.value.toUpperCase()">
                                            @error('razon_social')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="edit_serie">Serie (3 dígitos)</label>
                                            <input type="text" class="form-control @error('serie') is-invalid @enderror" id="edit_serie"
                                                name="serie" value="{{ old('serie') }}" maxlength="3" placeholder="001">
                                            @error('serie')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="edit_modo_pago">Modo de Pago</label>
                                            <select class="form-control @error('modo_pago') is-invalid @enderror" id="edit_modo_pago" name="modo_pago" required>
                                                <option value="gratuito">Gratuito (No paga)</option>
                                                <option value="mensual">Mensual</option>
                                                <option value="anual">Anual</option>
                                            </select>
                                            @error('modo_pago')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-5">
                                        <div class="form-group">
                                            <label for="edit_nombre_comercial">Nombre Comercial (Opcional)</label>
                                            <input type="text"
                                                class="form-control text-uppercase @error('nombre_comercial') is-invalid @enderror"
                                                id="edit_nombre_comercial" name="nombre_comercial"
                                                value="{{ old('nombre_comercial') }}"
                                                oninput="this.value = this.value.toUpperCase()">
                                            @error('nombre_comercial')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="edit_sitio_web">Sitio Web (URL)</label>
                                    <input type="url" class="form-control @error('sitio_web') is-invalid @enderror" id="edit_sitio_web"
                                        name="sitio_web" value="{{ old('sitio_web') }}" placeholder="https://www.ejemplo.com">
                                    @error('sitio_web')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="row">
                                    @unless(auth()->user()->hasRole('operador'))
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="edit_usuario_sol">Usuario SOL (Opcional)</label>
                                            <input type="text"
                                                class="form-control @error('usuario_sol') is-invalid @enderror"
                                                id="edit_usuario_sol" name="usuario_sol"
                                                value="{{ old('usuario_sol') }}">
                                            @error('usuario_sol')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="edit_clave_sol">Clave SOL (Opcional)</label>
                                            <input type="text"
                                                class="form-control @error('clave_sol') is-invalid @enderror"
                                                id="edit_clave_sol" name="clave_sol" value="{{ old('clave_sol') }}">
                                            @error('clave_sol')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    @endunless
                                </div>

                                <div class="form-group">
                                    <label for="edit_descripcion">Descripción</label>
                                    <textarea class="form-control text-uppercase @error('descripcion') is-invalid @enderror" id="edit_descripcion" name="descripcion"
                                        rows="3" oninput="this.value = this.value.toUpperCase()">{{ old('descripcion') }}</textarea>
                                    @error('descripcion')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                @unless(auth()->user()->hasRole('operador'))
                                <h6 class="mt-3">Usuario Secundario</h6>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="edit_usuario_secundario_dni">DNI</label>
                                            <input type="text" class="form-control @error('usuario_secundario_dni') is-invalid @enderror" id="edit_usuario_secundario_dni"
                                                name="usuario_secundario_dni" value="{{ old('usuario_secundario_dni') }}" maxlength="8">
                                            @error('usuario_secundario_dni')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="edit_usuario_secundario_user">Usuario</label>
                                            <input type="text" class="form-control @error('usuario_secundario_user') is-invalid @enderror" id="edit_usuario_secundario_user"
                                                name="usuario_secundario_user" value="{{ old('usuario_secundario_user') }}">
                                            @error('usuario_secundario_user')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="edit_usuario_secundario_clave">Clave</label>
                                            <input type="text" class="form-control @error('usuario_secundario_clave') is-invalid @enderror" id="edit_usuario_secundario_clave"
                                                name="usuario_secundario_clave" value="{{ old('usuario_secundario_clave') }}">
                                            @error('usuario_secundario_clave')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="edit_clave_certificado">Clave del Certificado</label>
                                    <input type="text" class="form-control @error('clave_certificado') is-invalid @enderror" id="edit_clave_certificado"
                                        name="clave_certificado" value="{{ old('clave_certificado') }}">
                                    @error('clave_certificado')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endunless

                                

                                    @unless(auth()->user()->hasRole('operador'))
                                        <div class="form-group mt-3">
                                            <label class="font-weight-bold">Asignar Responsables</label>
                                            <div class="card bg-light">
                                                <div class="card-body" style="max-height: 200px; overflow-y: auto;">
                                                    @foreach($proveedores as $proveedor)
                                                        <div class="custom-control custom-checkbox mb-2">
                                                            <input type="checkbox" name="proveedores[]" 
                                                                class="custom-control-input edit-proveedor-checkbox" 
                                                                id="edit_proveedor_{{ $proveedor->id }}" 
                                                                value="{{ $proveedor->id }}">
                                                            <label class="custom-control-label" for="edit_proveedor_{{ $proveedor->id }}">
                                                                {{ $proveedor->nombre_corto }}
                                                            </label>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                            <small class="text-muted">Seleccione los responsables que tendrán acceso a esta empresa.</small>
                                        </div>
                                    @endunless
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Actualizar Empresa</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Modal Agregar Tareas -->
    <div class="modal fade" id="addTareasModal" tabindex="-1" role="dialog" aria-labelledby="addTareasModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addTareasModalLabel">Agregar Tareas a <span
                            id="addTareasEmpresaName"></span></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="addTareasForm" method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="card mb-3">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h5>Nuevas Tareas</h5>
                                <button type="button" class="btn btn-sm btn-success" onclick="agregarTareaModal()">
                                    <i class="fas fa-plus"></i> Agregar Tarea
                                </button>
                            </div>
                            <div class="card-body">
                                <div id="modal-tareas-container">
                                    <!-- Dynamic tasks -->
                                </div>
                                <div class="alert alert-info mt-3">
                                    <i class="fas fa-info-circle"></i>
                                    <strong>Nota:</strong> Las nuevas tareas se agregarán al final de la lista actual.
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Guardar Tareas</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Modal Agregar RUC (Dinámico) -->
    <div class="modal fade" id="addRucModal" tabindex="-1" role="dialog" aria-labelledby="addRucModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <!-- Content loaded via AJAX -->
            </div>
        </div>
    </div>
    <!-- Modal Eliminar Empresa -->
    <div class="modal fade" id="deleteEmpresaModal" tabindex="-1" role="dialog" aria-labelledby="deleteEmpresaModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title" id="deleteEmpresaModalLabel">Confirmar Eliminación</h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="text-center mb-3">
                        <i class="fas fa-exclamation-triangle text-warning fa-3x"></i>
                    </div>
                    <p class="text-center font-weight-bold">¿Estás seguro de que deseas eliminar esta empresa?</p>
                    <p class="text-center text-muted">Esta acción eliminará la empresa <strong id="deleteEmpresaName"></strong> y todas sus tareas asociadas permanentemente. Esta acción no se puede deshacer.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    <form id="deleteEmpresaForm" method="POST" action="">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">Sí, eliminar empresa</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Ver Tarea (Nested) -->
    <div class="modal fade" id="showTareaModal" tabindex="-1" role="dialog" aria-labelledby="showTareaModalLabel"
        aria-hidden="true" style="z-index: 1060;"> <!-- Higher z-index than standard modal (1050) -->
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content" id="showTareaModalContent">
                <!-- Content loaded via AJAX -->
            </div>
        </div>
    </div>

    <!-- Modal Editar Tarea (Nested) -->
    <div class="modal fade" id="editTareaModal" tabindex="-1" role="dialog" aria-labelledby="editTareaModalLabel"
        aria-hidden="true" style="z-index: 1060;">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content" id="editTareaModalContent">
                 <!-- Content loaded via AJAX -->
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        // Live Search
        let searchTimeout;
        const searchInput = document.querySelector('input[name="search"]');
        
        if (searchInput) {
            searchInput.addEventListener('keyup', function() {
                clearTimeout(searchTimeout);
                const query = this.value;
                
                searchTimeout = setTimeout(() => {
                    const url = `{{ route('empresas.index') }}?search=${encodeURIComponent(query)}`;
                    
                    fetch(url, {
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    })
                    .then(response => response.text())
                    .then(html => {
                        document.getElementById('empresas-container').innerHTML = html;
                        
                        // Update the browser URL without reloading
                        const newUrl = new URL(window.location);
                        if (query) {
                            newUrl.searchParams.set('search', query);
                        } else {
                            newUrl.searchParams.delete('search');
                        }
                        window.history.pushState({}, '', newUrl);
                    })
                    .catch(error => console.error('Error:', error));
                }, 300);
            });
        }

        function confirmDeleteEmpresa(id, name) {
            $('#deleteEmpresaModal').modal('show');
            $('#deleteEmpresaName').text(name);
            $('#deleteEmpresaForm').attr('action', '{{ url("empresas") }}/' + id);
        }

        function showEmpresaDetails(id) {
            $('#showEmpresaModal').modal('show');
            // Show loading state
            $('#showEmpresaModalContent').html(`
                <div class="modal-header">
                    <h5 class="modal-title">Cargando...</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary" role="status">
                            <span class="sr-only">Cargando...</span>
                        </div>
                    </div>
                </div>
            `);
            
            var url = '{{ route("empresas.modal-content", ":id") }}';
            url = url.replace(':id', id);
            
            $.get(url, function(data) {
                $('#showEmpresaModalContent').html(data);
            }).fail(function() {
                $('#showEmpresaModalContent').html(`
                    <div class="modal-header">
                        <h5 class="modal-title">Error</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-danger">Error al cargar los detalles.</div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                    </div>
                `);
            });
        }

        // Global variable to track current company context
        let currentEmpresaId = null;

        let currentSort = { field: 'orden', direction: 'asc' };
        let currentFilter = 'todos';

        function showEmpresaTareas(id, filter = 'todos') {
            currentEmpresaId = id;
            currentFilter = filter; // Use provided filter or default to 'todos'
            // Optionally reset sort too, or keep it.
            var url = '{{ route("empresas.modal-tareas", ":id") }}'.replace(':id', id);
            // Append default params
            url += '?sort_by=' + currentSort.field + '&order=' + currentSort.direction + '&estado=' + currentFilter;
            loadEmpresaTareas(url);
        }

        function loadEmpresaTareas(url) {
            $('#showEmpresaModal').modal('show');
            
            // Check if we are checking the same company to decide whether to show loading or not
            // Or just always show loading for feedback.
            // Simplified loading state
            $('#showEmpresaModalContent').html(`
                <div class="modal-header">
                    <h5 class="modal-title">Cargando Tareas...</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body text-center py-5">
                    <div class="spinner-border text-primary" role="status">
                        <span class="sr-only">Cargando...</span>
                    </div>
                </div>
            `);

            // Append sort params if not present
            // Params are now handled by callers (showEmpresaTareas, sort handler, updateTaskFilter)
            // or by pagination links themselves.

            $.get(url, function(data) {
                $('#showEmpresaModalContent').html(data);
                
                // Update sort icons
                $('.sort-link').each(function() {
                    var field = $(this).data('sort');
                    var icon = $(this).find('i');
                    icon.attr('class', 'fas fa-sort'); 
                    if (field === currentSort.field) {
                        icon.attr('class', currentSort.direction === 'asc' ? 'fas fa-sort-up' : 'fas fa-sort-down');
                    }
                });

            }).fail(function() {
                $('#showEmpresaModalContent').html(`
                    <div class="modal-body">
                        <div class="alert alert-danger">Error al cargar las tareas.</div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                    </div>
                `);
            });
        }

        // Pagination Click Handler
        $(document).on('click', '#tareas-pagination .pagination a', function(e) {
            e.preventDefault();
            var url = $(this).attr('href');
            loadEmpresaTareas(url);
        });

        // Sort Click Handler
        $(document).on('click', '.sort-link', function(e) {
            e.preventDefault();
            var field = $(this).data('sort');
            
            if (currentSort.field === field) {
                currentSort.direction = currentSort.direction === 'asc' ? 'desc' : 'asc';
            } else {
                currentSort.field = field;
                currentSort.direction = 'asc';
            }

            var baseUrl = '{{ route("empresas.modal-tareas", ":id") }}'.replace(':id', currentEmpresaId);
            var url = baseUrl + '?sort_by=' + currentSort.field + '&order=' + currentSort.direction + '&estado=' + currentFilter;
            
            loadEmpresaTareas(url);
        });

        function updateTaskFilter(status) {
            currentFilter = status;
            var baseUrl = '{{ route("empresas.modal-tareas", ":id") }}'.replace(':id', currentEmpresaId);
            var url = baseUrl + '?sort_by=' + currentSort.field + '&order=' + currentSort.direction + '&estado=' + currentFilter;
            loadEmpresaTareas(url);
        }

        // Show Add Task Form
        function showAddTareasModal(id) {
            currentEmpresaId = id;
            var url = '{{ route("empresas.modal-add-tasks", ":id") }}'.replace(':id', id);
            
            $('#showEmpresaModalContent').html(`
                <div class="modal-body text-center py-5">
                    <div class="spinner-border text-success" role="status">
                        <span class="sr-only">Cargando...</span>
                    </div>
                </div>
            `);

            $.get(url, function(data) {
                $('#showEmpresaModalContent').html(data);
            }).fail(function() {
                alert('Error al cargar el formulario.');
                showEmpresaTareas(id); // Go back
            });
        }

        // AJAX submit for Add Task
        $(document).on('submit', '#addTaskForm', function(e) {
            e.preventDefault();
            var form = $(this);
            var url = form.attr('action');
            var submitBtn = form.find('button[type="submit"]');
            var originalText = submitBtn.html();

            submitBtn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Guardando...');

            $.ajax({
                type: "POST",
                url: url,
                data: form.serialize(),
                headers: { 'X-Requested-With': 'XMLHttpRequest' },
                success: function(response) {
                    // Navigate back to the list
                    showEmpresaTareas(currentEmpresaId);
                    // Optional: Show toast or alert? 
                    // Since showEmpresaTareas reloads the modal, maybe just trust the user sees the new task.
                },
                error: function(xhr) {
                    submitBtn.prop('disabled', false).html(originalText);
                    if (xhr.status === 422) {
                        var errors = xhr.responseJSON.errors;
                        var errorMsg = '';
                        $.each(errors, function(k, v) { errorMsg += v + '\n'; });
                        alert('Errores de validación:\n' + errorMsg);
                    } else {
                        alert('Error al guardar la tarea.');
                    }
                }
            });
        });

        // AJAX Delete Task
        $(document).on('submit', '.delete-task-form', function(e) {
            e.preventDefault();
            if (!confirm('¿Estás seguro de eliminar esta tarea?')) return;

            var form = $(this);
            var url = form.attr('action');
            var btn = form.find('button');
            var originalContent = btn.html();

            btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i>');

            $.ajax({
                type: "POST", // Method spoofing usually used in Laravel forms
                url: url,
                data: form.serialize(),
                headers: { 'X-Requested-With': 'XMLHttpRequest' },
                success: function(response) {
                    showEmpresaTareas(currentEmpresaId);
                },
                error: function(xhr) {
                    btn.prop('disabled', false).html(originalContent);
                    alert('Error al eliminar la tarea.');
                }
            });
        });

        // Funcionalidad para el modal de Crear Empresa
        let tareaIndex = 0;

        function agregarTarea() {
            const container = document.getElementById('tareas-container');
            const tareaHtml = `
        <div class="tarea-item border rounded p-3 mb-3" data-index="${tareaIndex}">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h6>Tarea ${tareaIndex + 1}</h6>
                <button type="button" class="btn btn-sm btn-danger" onclick="eliminarTarea(${tareaIndex})">
                    <i class="fas fa-trash"></i>
                </button>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Título de la Tarea</label>
                        <input type="text" class="form-control text-uppercase" name="tareas[${tareaIndex}][titulo]" required oninput="this.value = this.value.toUpperCase()">
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Prioridad</label>
                        <select class="form-control" name="tareas[${tareaIndex}][prioridad]" required>
                            <option value="baja">Baja</option>
                            <option value="media" selected>Media</option>
                            <option value="alta">Alta</option>
                            <option value="urgente">Urgente</option>
                        </select>
                    </div>
                </div>
            </div>
            
            <div class="form-group">
                <label>Descripción</label>
                <textarea class="form-control text-uppercase" name="tareas[${tareaIndex}][descripcion]" rows="2" required oninput="this.value = this.value.toUpperCase()"></textarea>
            </div>
            
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Fecha Inicio Estimada</label>
                        <input type="date" class="form-control" name="tareas[${tareaIndex}][fecha_inicio_estimada]" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Fecha Fin Estimada</label>
                        <input type="date" class="form-control" name="tareas[${tareaIndex}][fecha_fin_estimada]" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Operador Asignado</label>
                        <select class="form-control" name="tareas[${tareaIndex}][operador_id]" required>
                            <option value="">Seleccionar operador</option>
                            @foreach ($operadores as $operador)
                                <option value="{{ $operador->id }}">{{ $operador->nombre_completo }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
        </div>
    `;

            container.insertAdjacentHTML('beforeend', tareaHtml);
            tareaIndex++;
        }


        function eliminarTarea(index) {
            const tarea = document.querySelector(`.tarea-item[data-index="${index}"]`);
            if (tarea) {
                tarea.remove();
            }
        }

        function showTareaDetails(id) {
            // Ensure first modal stays open but second one appears on top
            $('#showTareaModal').modal('show');
            
            // Fix Bootstrap modal stacking issue manually if needed
            // Usually Bootstrap handles it, but sometimes z-index needs help
            $('#showTareaModal').on('shown.bs.modal', function () {
                // Ensure layout doesn't break
                $('body').addClass('modal-open');
            });

            $('#showTareaModalContent').html(`
                <div class="modal-header">
                    <h5 class="modal-title">Cargando Detalle...</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary" role="status">
                            <span class="sr-only">Cargando...</span>
                        </div>
                    </div>
                </div>
            `);
            
            var url = '{{ route("tareas.modal-content", ":id") }}';
            url = url.replace(':id', id);
            
            $.get(url, function(data) {
                $('#showTareaModalContent').html(data);
                // Scroll chat to bottom
                var chatDiv = document.getElementById('chat-messages');
                if (chatDiv) {
                    chatDiv.scrollTop = chatDiv.scrollHeight;
                }
            }).fail(function() {
                $('#showTareaModalContent').html(`
                    <div class="modal-body">
                        <div class="alert alert-danger">Error al cargar el detalle de la tarea.</div>
                    </div>
                `);
            });
        }

        function showEditTareaModal(id) {
             $('#editTareaModal').modal('show');
             $('#editTareaModal').on('shown.bs.modal', function () {
                $('body').addClass('modal-open');
            });

            $('#editTareaModalContent').html(`
                <div class="modal-header">
                    <h5 class="modal-title">Cargando Edición...</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary" role="status">
                            <span class="sr-only">Cargando...</span>
                        </div>
                    </div>
                </div>
            `);

            var url = '{{ route("tareas.modal-edit-content", ":id") }}';
            url = url.replace(':id', id);

            $.get(url, function(data) {
                $('#editTareaModalContent').html(data);
            }).fail(function() {
                 $('#editTareaModalContent').html(`
                    <div class="modal-body">
                        <div class="alert alert-danger">Error al cargar el formulario de edición.</div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                    </div>
                `);
            });
        }


<!-- Add this modal at the end of the section content or outside other modals -->


        document.getElementById('agregarTarea').addEventListener('click', agregarTarea);

        // Funcionalidad para Modal Agregar Tareas
        let tareaModalIndex = 0;
        let ultimoOrdenModal = 0;

        function openAddTareasModal(id, nombre, maxOrden) {
            $('#addTareasModal').modal('show');
            $('#addTareasEmpresaName').text(nombre);
            $('#addTareasForm').attr('action', '{{ url("empresas") }}/' + id + '/add-tareas');
            
            ultimoOrdenModal = parseInt(maxOrden);
            tareaModalIndex = 0;
            document.getElementById('modal-tareas-container').innerHTML = '';
            
            // Add one empty task by default
            agregarTareaModal();
        }

        function agregarTareaModal() {
            const container = document.getElementById('modal-tareas-container');
            const nuevoOrden = ultimoOrdenModal + tareaModalIndex + 1;
            
            const tareaHtml = `
                <div class="tarea-modal-item border rounded p-3 mb-3" data-index="${tareaModalIndex}">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h6>Tarea ${nuevoOrden} (Nueva)</h6>
                        <button type="button" class="btn btn-sm btn-danger" onclick="eliminarTareaModal(${tareaModalIndex})">
                            <i class="fas fa-trash"></i> Eliminar
                        </button>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Título de la Tarea</label>
                                <input type="text" class="form-control text-uppercase" name="tareas[${tareaModalIndex}][titulo]" required oninput="this.value = this.value.toUpperCase()">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Prioridad</label>
                                <select class="form-control" name="tareas[${tareaModalIndex}][prioridad]" required>
                                    <option value="baja">Baja</option>
                                    <option value="media" selected>Media</option>
                                    <option value="alta">Alta</option>
                                    <option value="urgente">Urgente</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>Descripción</label>
                        <textarea class="form-control text-uppercase" name="tareas[${tareaModalIndex}][descripcion]" rows="2" required oninput="this.value = this.value.toUpperCase()"></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Fecha Inicio Estimada</label>
                                <input type="date" class="form-control" name="tareas[${tareaModalIndex}][fecha_inicio_estimada]" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Fecha Fin Estimada</label>
                                <input type="date" class="form-control" name="tareas[${tareaModalIndex}][fecha_fin_estimada]" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Operador Asignado</label>
                                <select class="form-control" name="tareas[${tareaModalIndex}][operador_id]" required>
                                    <option value="">Seleccionar operador</option>
                                    @foreach ($operadores as $operador)
                                        <option value="{{ $operador->id }}">{{ $operador->nombre_completo }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            `;
            
            container.insertAdjacentHTML('beforeend', tareaHtml);
            tareaModalIndex++;
        }

        function eliminarTareaModal(index) {
            const tarea = document.querySelector(`.tarea-modal-item[data-index="${index}"]`);
            if (tarea) {
                tarea.remove();
            }
        }

        // Inicialización y Manejo de Errores
        document.addEventListener('DOMContentLoaded', function() {
            // agregarTarea();

            @if ($errors->any())
                @if(old('_method') == 'PATCH')
                    $('#editEmpresaModal').modal('show');
                @else
                    $('#createEmpresaModal').modal('show');
                @endif
            @endif

            $('[data-toggle=\"tooltip\"]').tooltip();
        });

        // Funcionalidad para el modal de Editar Empresa
        $('#editEmpresaModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget);
            // Si el modal se abre por error de validación, no sobrescribir los valores 'old'
            if (button.length && button.data('id')) {
                var modal = $(this);
                
                var id = button.data('id');
                var ruc = button.data('ruc');
                var razonSocial = button.data('razon-social');
                var nombreComercial = button.data('nombre-comercial');
                var serie = button.data('serie');
                var modoPago = button.data('modo-pago');
                // var estado = button.data('estado'); // Removed
                var usuarioSol = button.data('usuario-sol');
                var claveSol = button.data('clave-sol');
                var descripcion = button.data('descripcion');
                var fechaSolicitud = button.data('fecha-solicitud');
                var usDni = button.data('usuario-secundario-dni');
                var usUser = button.data('usuario-secundario-user');
                var usClave = button.data('usuario-secundario-clave');
                var claveCertificado = button.data('clave-certificado');
                var sitioWeb = button.data('sitio-web');

                modal.find('.modal-title').text('Editar Empresa: ' + razonSocial);
                modal.find('#editEmpresaForm').attr('action', '{{ url("empresas") }}/' + id);
                
                modal.find('#edit_ruc').val(ruc);
                modal.find('#edit_razon_social').val(razonSocial);
                modal.find('#edit_nombre_comercial').val(nombreComercial);
                modal.find('#edit_serie').val(serie);
                modal.find('#edit_modo_pago').val(modoPago);
                // modal.find('#edit_estado').val(estado); // Removed
                modal.find('#edit_sitio_web').val(sitioWeb);
                modal.find('#edit_usuario_sol').val(usuarioSol);
                modal.find('#edit_clave_sol').val(claveSol);
                modal.find('#edit_descripcion').val(descripcion);
                modal.find('#edit_fecha_solicitud').val(fechaSolicitud);
                modal.find('#edit_usuario_secundario_dni').val(usDni);
                modal.find('#edit_usuario_secundario_user').val(usUser);
                modal.find('#edit_usuario_secundario_clave').val(usClave);
                modal.find('#edit_clave_certificado').val(claveCertificado);

                // Cargar proveedores asignados
                var proveedores = button.data('proveedores');
                modal.find('.edit-proveedor-checkbox').prop('checked', false);
                
                if (proveedores && Array.isArray(proveedores)) {
                    proveedores.forEach(function(id) {
                         modal.find('#edit_proveedor_' + id).prop('checked', true);
                    });
                }
            }
        });


        // Fix for stacked modals scroll issue
        $(document).on('hidden.bs.modal', '.modal', function () {
            $('.modal:visible').length && $(document.body).addClass('modal-open');
        });

        // AJAX submit for Edit Task Form
        $(document).on('submit', '#editTareaForm', function(e) {
            e.preventDefault();
            var form = $(this);
            var url = form.attr('action');
            var modalContent = $('#editTareaModalContent');
            
            // Show loading state on button
            var submitBtn = form.find('button[type="submit"]');
            var originalBtnText = submitBtn.html();
            submitBtn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Guardando...');

            $.ajax({
                type: "POST",
                url: url,
                data: form.serialize(),
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                },
                success: function(response) {
                    $('#editTareaModal').modal('hide');
                    if (currentEmpresaId) {
                        showEmpresaTareas(currentEmpresaId);
                    } else {
                         location.reload(); 
                    }
                },
                error: function(xhr) {
                    submitBtn.prop('disabled', false).html(originalBtnText);
                    if (xhr.status === 422) { // Validation error
                         var errors = xhr.responseJSON.errors;
                         var errorHtml = '<div class="alert alert-danger"><ul>';
                         $.each(errors, function (key, val) {
                             errorHtml += '<li>' + val + '</li>';
                         });
                         errorHtml += '</ul></div>';
                         
                         var existingAlert = modalContent.find('.alert.alert-danger');
                         if (existingAlert.length) {
                             existingAlert.remove();
                         }
                         modalContent.find('.modal-body').prepend(errorHtml);
                    } else {
                        alert('Error al guardar cambios. Por favor intente nuevamente.');
                    }
                }
            });
        });

        // AJAX submit for Upload Material using FormData
        $(document).on('submit', '#uploadMaterialForm', function(e) {
            e.preventDefault();
            var form = $(this);
            var url = form.attr('action');
            var formData = new FormData(this);
            var submitBtn = form.find('button[type="submit"]');
            var originalBtnText = submitBtn.html();

            submitBtn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i>');

            $.ajax({
                type: "POST",
                url: url,
                data: formData,
                processData: false,
                contentType: false,
                headers: { 'X-Requested-With': 'XMLHttpRequest' },
                success: function(response) {
                    // Reload the modal content to show new list
                    // We need the task ID. Best way is to extract it from the current form action or url
                    // The edit modal url is like /tareas/{id}/modal-edit-content
                    // We can store the current Task ID when opening the modal, or just regex it from the upload url
                    // The upload url is /tareas/{id}/material. matches /tareas/(\d+)/material
                    var match = url.match(/\/tareas\/(\d+)\/material/);
                    if (match) {
                        showEditTareaModal(match[1]); // Reloads content
                    }
                },
                error: function(xhr) {
                    submitBtn.prop('disabled', false).html(originalBtnText);
                    alert('Error al subir archivo. Verifique el tamaño (max 10MB).');
                }
            });
        });

        // Delete Material
        $(document).on('click', '.btn-delete-material', function() {
            if(!confirm('¿Estás seguro de eliminar este archivo?')) return;
            
            var btn = $(this);
            var url = btn.data('url');
            
            $.ajax({
                type: "DELETE",
                url: url,
                data: { _token: '{{ csrf_token() }}' },
                success: function(response) {
                     // Reload modal content. extract task id.
                     // The button is inside the modal, we can find the upload form to get the task id
                     var formAction = $('#uploadMaterialForm').attr('action');
                     var match = formAction.match(/\/tareas\/(\d+)\/material/);
                     if (match) {
                        showEditTareaModal(match[1]);
                     } else {
                         btn.closest('.d-flex').remove(); // Fallback
                     }
                },
                error: function() {
                    alert('Error al eliminar archivo.');
                }
            });
        });

        // Custom file input label update
        $(document).on('change', '.custom-file-input', function (event) {
            var inputFile = event.currentTarget;
            $(inputFile).parent()
                .find('.custom-file-label')
                .html(inputFile.files[0].name);
        });

        // AJAX submit for Add Comment
        $(document).on('submit', '#addCommentForm', function(e) {
            e.preventDefault();
            var form = $(this);
            var url = form.attr('action');
            var submitBtn = form.find('button[type="submit"]');
            var icon = submitBtn.find('i');
            
            // Disable button
            submitBtn.prop('disabled', true);
            icon.attr('class', 'fas fa-spinner fa-spin');

            $.ajax({
                type: "POST",
                url: url,
                data: form.serialize(),
                headers: { 'X-Requested-With': 'XMLHttpRequest' },
                success: function(response) {
                    // Extract task ID from url: /tareas/{id}/comment
                    var match = url.match(/\/tareas\/(\d+)\/comment/);
                    if (match) {
                        showTareaDetails(match[1]); // Reload modal content
                    }
                },
                error: function(xhr) {
                    submitBtn.prop('disabled', false);
                    icon.attr('class', 'fas fa-paper-plane');
                    alert('Error al enviar comentario. Intente nuevamente.');
                }
            });
        });

        // Detect when #chat-messages is added and scroll
         var observer = new MutationObserver(function(mutations) {
            mutations.forEach(function(mutation) {
                if (mutation.addedNodes.length) {
                    var chatDiv = document.getElementById('chat-messages');
                    if (chatDiv) {
                        chatDiv.scrollTop = chatDiv.scrollHeight;
                        // Optional: disconnect if we only want to do it once per modal open
                        // observer.disconnect();
                    }
                }
            });
        });
        
        // Start observing the target node for configured mutations
        // observer.observe(document.body, { childList: true, subtree: true });
        
        // Better yet, just call scroll in the AJAX success of showTareaDetails. (Already done there).


        // --- RUC MODAL FUNCTIONS ---

        window.showRucsModal = function(companyId) {
             $('#addRucModal').modal('show');
             showRucList(companyId);
        }

        window.showRucList = function(companyId) {
            $('#addRucModal .modal-content').html(`
                <div class="modal-header">
                    <h5 class="modal-title">Cargando RUCs...</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body text-center py-5">
                    <div class="spinner-border text-primary" role="status">
                        <span class="sr-only">Cargando...</span>
                    </div>
                </div>
            `);

            var url = '{{ route("empresas.modal-rucs", ":id") }}'.replace(':id', companyId);
            
            $.get(url, function(data) {
                $('#addRucModal .modal-content').html(data);
            }).fail(function() {
                $('#addRucModal .modal-content').html(`
                    <div class="modal-header">
                        <h5 class="modal-title">Error</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                         <div class="alert alert-danger">Error al cargar la lista de RUCs.</div>
                    </div>
                `);
            });
        }

        window.loadAddRucForm = function(companyId) {
             $('#addRucModal .modal-content').html(`
                <div class="modal-header">
                    <h5 class="modal-title">Cargando formulario...</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body text-center py-5">
                    <div class="spinner-border text-primary" role="status">
                        <span class="sr-only">Cargando...</span>
                    </div>
                </div>
            `);

            var url = '{{ route("empresas.modal-ruc-form", ":id") }}'.replace(':id', companyId);

            $.get(url, function(data) {
                $('#addRucModal .modal-content').html(data);
            }).fail(function() {
                 $('#addRucModal .modal-content').html(`
                    <div class="modal-header">
                        <h5 class="modal-title">Error</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                         <div class="alert alert-danger">Error al cargar el formulario.</div>
                         <button class="btn btn-secondary mt-3" onclick="showRucList(${companyId})">Volver</button>
                    </div>
                `);
            });
        }
        
        // AJAX submit for Edit RUC
        $(document).on('submit', '#editRucForm', function(e) {
            e.preventDefault();
            var form = $(this);
            var url = form.attr('action');
            var companyId = form.data('company-id');
            var submitBtn = form.find('button[type="submit"]');
            var originalBtnText = submitBtn.html();

            submitBtn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Actualizando...');

            $.ajax({
                type: "POST",
                url: url,
                data: form.serialize(),
                success: function(response) {
                    showRucList(companyId);
                },
                error: function(xhr) {
                    submitBtn.prop('disabled', false).html(originalBtnText);
                    alert('Error al actualizar el RUC. Verifique los datos.');
                }
            });
        });

        window.loadEditRucForm = function(rucId) {
             $('#addRucModal .modal-content').html(`
                <div class="modal-header">
                    <h5 class="modal-title">Cargando formulario...</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body text-center py-5">
                    <div class="spinner-border text-primary" role="status">
                        <span class="sr-only">Cargando...</span>
                    </div>
                </div>
            `);

            var url = '{{ route("empresas.rucs.modal-edit", ":id") }}'.replace(':id', rucId);

            $.get(url, function(data) {
                $('#addRucModal .modal-content').html(data);
            }).fail(function() {
                 $('#addRucModal .modal-content').html(`
                    <div class="modal-header">
                        <h5 class="modal-title">Error</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                         <div class="alert alert-danger">Error al cargar el formulario de edición.</div>
                    </div>
                `);
            });
        }

        window.deleteRuc = function(url, companyId) {
            if(!confirm('¿Estás seguro de eliminar este RUC?')) return;

            $.ajax({
                type: "POST",
                url: url,
                data: { _method: 'DELETE', _token: '{{ csrf_token() }}' },
                success: function(response) {
                    showRucList(companyId); // Reload list
                },
                error: function() {
                    alert('Error al eliminar RUC.');
                }
            });
        }
        
        // Change Status Modal
        $('#changeStatusModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget);
            var id = button.data('id');
            var estado = button.data('estado');
            var nombre = button.data('nombre');
            
            var modal = $(this);
            modal.find('#statusEmpresaName').text(nombre);
            modal.find('#new_estado').val(estado);
            
            var actionUrl = '{{ url("empresas") }}/' + id + '/update-status';
            modal.find('#changeStatusForm').attr('action', actionUrl);
        });
        
    </script>
@endsection
