@extends('layouts.app')

@section('content')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Editar Empresa: {{ $empresa->razon_social }}</h1>
        <a href="{{ route('empresas.show', $empresa->id) }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Volver
        </a>
    </div>

    <form method="POST" action="{{ route('empresas.update', $empresa->id) }}">
        @csrf
        @method('PATCH')

        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h5>Información de la Empresa</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="ruc">RUC</label>
                                    <input type="text" class="form-control @error('ruc') is-invalid @enderror" id="ruc"
                                        name="ruc" value="{{ old('ruc', $empresa->ruc) }}" required maxlength="11">
                                    @error('ruc')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="razon_social">Razón Social</label>
                                    <input type="text" class="form-control text-uppercase @error('razon_social') is-invalid @enderror" id="razon_social"
                                        name="razon_social" value="{{ old('razon_social', $empresa->razon_social) }}" required
                                        oninput="this.value = this.value.toUpperCase()">
                                    @error('razon_social')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="serie">Serie (3 dígitos)</label>
                                    <input type="text" class="form-control @error('serie') is-invalid @enderror" id="serie"
                                        name="serie" value="{{ old('serie', $empresa->serie) }}" maxlength="3" placeholder="001">
                                    @error('serie')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label for="nombre_comercial">Nombre Comercial (Opcional)</label>
                                    <input type="text" class="form-control text-uppercase @error('nombre_comercial') is-invalid @enderror" id="nombre_comercial"
                                        name="nombre_comercial" value="{{ old('nombre_comercial', $empresa->nombre_comercial) }}"
                                        oninput="this.value = this.value.toUpperCase()">
                                    @error('nombre_comercial')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="sitio_web">Sitio Web (URL)</label>
                            <input type="url" class="form-control @error('sitio_web') is-invalid @enderror" id="sitio_web"
                                name="sitio_web" value="{{ old('sitio_web', $empresa->sitio_web) }}" placeholder="https://www.ejemplo.com">
                            @error('sitio_web')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            @unless(auth()->user()->hasRole('operador'))
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="usuario_sol">Usuario SOL (Opcional)</label>
                                    <input type="text" class="form-control @error('usuario_sol') is-invalid @enderror" id="usuario_sol"
                                        name="usuario_sol" value="{{ old('usuario_sol', $empresa->usuario_sol) }}">
                                    @error('usuario_sol')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="clave_sol">Clave SOL (Opcional)</label>
                                    <input type="text" class="form-control @error('clave_sol') is-invalid @enderror" id="clave_sol"
                                        name="clave_sol" value="{{ old('clave_sol', $empresa->clave_sol) }}">
                                    @error('clave_sol')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            @endunless
                        </div>

                        @unless(auth()->user()->hasRole('operador'))
                        <h6 class="mt-3">Usuario Secundario</h6>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="usuario_secundario_dni">DNI</label>
                                    <input type="text" class="form-control @error('usuario_secundario_dni') is-invalid @enderror" id="usuario_secundario_dni"
                                        name="usuario_secundario_dni" value="{{ old('usuario_secundario_dni', $empresa->usuario_secundario_dni) }}" maxlength="8">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="usuario_secundario_user">Usuario</label>
                                    <input type="text" class="form-control @error('usuario_secundario_user') is-invalid @enderror" id="usuario_secundario_user"
                                        name="usuario_secundario_user" value="{{ old('usuario_secundario_user', $empresa->usuario_secundario_user) }}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="usuario_secundario_clave">Clave</label>
                                    <input type="text" class="form-control @error('usuario_secundario_clave') is-invalid @enderror" id="usuario_secundario_clave"
                                        name="usuario_secundario_clave" value="{{ old('usuario_secundario_clave', $empresa->usuario_secundario_clave) }}">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="clave_certificado">Clave del Certificado</label>
                            <input type="text" class="form-control @error('clave_certificado') is-invalid @enderror" id="clave_certificado"
                                name="clave_certificado" value="{{ old('clave_certificado', $empresa->clave_certificado) }}">
                        </div>
                        @endunless

                        <div class="form-group">
                            <label for="descripcion">Descripción</label>
                            <textarea class="form-control text-uppercase @error('descripcion') is-invalid @enderror" id="descripcion" name="descripcion"
                                rows="3" oninput="this.value = this.value.toUpperCase()">{{ old('descripcion', $empresa->descripcion) }}</textarea>
                            @error('descripcion')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        

                        @if(auth()->user()->hasRole('administrador'))
                            <div class="form-group mt-3">
                                <label class="font-weight-bold">Asignar Responsables</label>
                                <div class="card bg-light">
                                    <div class="card-body" style="max-height: 200px; overflow-y: auto;">
                                        @foreach($proveedores as $proveedor)
                                            <div class="custom-control custom-checkbox mb-2">
                                                <input type="checkbox" name="proveedores[]" 
                                                    class="custom-control-input" 
                                                    id="proveedor_{{ $proveedor->id }}" 
                                                    value="{{ $proveedor->id }}"
                                                    {{ $empresa->proveedores->contains($proveedor->id) ? 'checked' : '' }}>
                                                <label class="custom-control-label" for="proveedor_{{ $proveedor->id }}">
                                                    {{ $proveedor->nombre_corto }}
                                                </label>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                                <small class="text-muted">Seleccione los responsables que tendrán acceso a esta empresa.</small>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h5>Estado Actual</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="estado"><strong>Estado:</strong></label>
                            @if(auth()->user()->hasRole('administrador'))
                                <select name="estado" id="estado" class="form-control">
                                    <option value="pendiente" {{ $empresa->estado == 'pendiente' ? 'selected' : '' }}>Pendiente</option>
                                    <option value="aprobada" {{ $empresa->estado == 'aprobada' ? 'selected' : '' }}>Aprobada (Vigente)</option>
                                    <option value="rechazada" {{ $empresa->estado == 'rechazada' ? 'selected' : '' }}>Rechazada</option>
                                    <option value="inactiva" {{ $empresa->estado == 'inactiva' ? 'selected' : '' }}>Inactiva (No Vigente)</option>
                                    <option value="retirada" {{ $empresa->estado == 'retirada' ? 'selected' : '' }}>Retirada</option>
                                </select>
                            @else
                                <span class="badge badge-{{ $empresa->estado === 'aprobada' ? 'success' : ($empresa->estado === 'pendiente' ? 'warning' : 'danger') }}">
                                    {{ ucfirst($empresa->estado) }}
                                </span>
                            @endif
                        </div>
                        <p><strong>Creada:</strong> {{ $empresa->created_at->format('d/m/Y H:i') }}</p>
                        <p><strong>Tareas:</strong> {{ $empresa->tareas->count() }}</p>

                        @if ($empresa->estado === 'pendiente')
                            <div class="alert alert-info">
                                <small>Solo puedes editar empresas pendientes de aprobación.</small>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <div class="mt-4">
            <button type="submit" class="btn btn-primary">Actualizar Empresa</button>
            <a href="{{ route('empresas.show', $empresa->id) }}" class="btn btn-secondary">Cancelar</a>
        </div>
    </form>
@endsection
