@extends('layouts.app')

@section('content')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Credenciales de Empresas</h1>
        @auth
            <!-- Logged in actions if needed -->
        @else
            <a href="{{ route('login') }}" class="btn btn-sm btn-outline-primary">Iniciar Sesión</a>
        @endauth
    </div>

    <div class="card mb-4">
        <div class="card-body">
            <form action="{{ route('empresas.credenciales') }}" method="GET">
                <div class="input-group">
                    <input type="text" name="search" class="form-control" placeholder="Buscar por RUC o Nombre"
                        value="{{ request('search') }}" aria-label="Buscar" aria-describedby="button-search">
                    <div class="input-group-append">
                        <button class="btn btn-outline-secondary" type="submit" id="button-search">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="table-responsive" id="credencialesTableContainer">
        @include('empresas.partials.credenciales_table')
    </div>

    <!-- Modal Credenciales -->
    <div class="modal fade" id="credencialesModal" tabindex="-1" role="dialog" aria-labelledby="credencialesModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header bg-info text-white">
                    <h5 class="modal-title" id="credencialesModalLabel">Credenciales SUNAT</h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div id="loadingCredenciales" class="text-center">
                        <div class="spinner-border text-primary" role="status">
                            <span class="sr-only">Cargando...</span>
                        </div>
                        <p class="mt-2">Obteniendo datos...</p>
                    </div>
                    <div id="infoCredenciales" style="display: none;">
                        <div class="form-group">
                            <label class="font-weight-bold">RUC:</label>
                            <p id="modalRuc" class="form-control-static lead"></p>
                        </div>
                        <div class="form-group">
                            <label class="font-weight-bold">Razón Social:</label>
                            <p id="modalRazonSocial" class="form-control-static"></p>
                        </div>
                        <div class="form-group">
                            <label class="font-weight-bold">Serie:</label>
                            <p id="modalSerie" class="form-control-static"></p>
                        </div>
                        <hr>
                        <div class="form-group">
                            <label class="font-weight-bold text-primary">Usuario SOL:</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="modalUsuarioSol" readonly>
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" type="button" onclick="copiarTexto('modalUsuarioSol')">
                                        <i class="fas fa-copy"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="font-weight-bold text-primary">Clave SOL:</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="modalClaveSol" readonly>
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" type="button" onclick="copiarTexto('modalClaveSol')">
                                        <i class="fas fa-copy"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        
                        <hr>
                        <h6 class="text-primary font-weight-bold">Usuario Secundario</h6>
                        <div class="form-group">
                            <label class="font-weight-bold">DNI:</label>
                            <input type="text" class="form-control" id="modalUsuarioSecundarioDni" readonly>
                        </div>
                        <div class="form-group">
                            <label class="font-weight-bold">Usuario:</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="modalUsuarioSecundarioUser" readonly>
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" type="button" onclick="copiarTexto('modalUsuarioSecundarioUser')">
                                        <i class="fas fa-copy"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="font-weight-bold">Clave:</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="modalUsuarioSecundarioClave" readonly>
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" type="button" onclick="copiarTexto('modalUsuarioSecundarioClave')">
                                        <i class="fas fa-copy"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        
                        <hr>
                        <div class="form-group">
                            <label class="font-weight-bold text-primary">Clave Certificado:</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="modalClaveCertificado" readonly>
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" type="button" onclick="copiarTexto('modalClaveCertificado')">
                                        <i class="fas fa-copy"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="errorCredenciales" class="alert alert-danger" style="display: none;">
                        No se pudo cargar la información.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        // Live Search, Sorting and Pagination
        let searchTimeout;
        const searchInput = document.querySelector('input[name="search"]');
        const tableContainer = document.getElementById('credencialesTableContainer');

        function fetchResults(url) {
            // Preserve search query if not present in URL
            if (searchInput && !url.includes('search=')) {
                const query = searchInput.value;
                if (query) {
                    url += (url.includes('?') ? '&' : '?') + 'search=' + encodeURIComponent(query);
                }
            }

            fetch(url, {
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => response.text())
            .then(html => {
                tableContainer.innerHTML = html;
            })
            .catch(error => console.error('Error:', error));
        }

        if (searchInput) {
            searchInput.addEventListener('keyup', function() {
                clearTimeout(searchTimeout);
                const query = this.value;

                searchTimeout = setTimeout(() => {
                    const url = '{{ route("empresas.credenciales") }}';
                    fetchResults(url);
                }, 300); 
            });
            
             searchInput.addEventListener('keypress', function(e) {
                if (e.key === 'Enter') {
                    e.preventDefault();
                }
            });
        }

        // Handle Pagination Clicks
        document.addEventListener('click', function(e) {
            if (e.target.closest('.pagination a')) {
                e.preventDefault();
                const url = e.target.closest('a').href;
                fetchResults(url);
            }
        });

        // Handle Sort Clicks
        document.addEventListener('click', function(e) {
            if (e.target.closest('.sort-link')) {
                e.preventDefault();
                const link = e.target.closest('.sort-link');
                const sortBy = link.dataset.sort;
                
                // Determine current sort order from icon (optional) or just toggle via URL params
                // But better: construct URL with params.
                // We need to know current state. We can grab it from URL or hidden inputs or simple logic:
                // If clicking same header, toggle. Default asc.
                
                const currentUrl = new URL(window.location.href);
                // Note: window.location.href might not reflect AJAX state perfectly if we don't pushState.
                // Better approach: Store state in JS variables or read from DOM.
                // Let's assume we want to sort the current VIEW.
                
                // Since we are not updating window URL (pushState), we need to extract current params from the *last fetched* state or defaults.
                // Simpler: Just allow the controller to handle it?
                // The sort links generated in blade COULD have the correct href if we re-render them.
                // But the `javascript:void(0)` in partial means we handle it here.

                // Let's check the partial again. The partial uses $sortBy variable.
                // So we can check the icon class to determine current order.
                const icon = link.querySelector('i');
                let sortOrder = 'asc';
                if (icon.classList.contains('fa-sort-up')) {
                    sortOrder = 'desc';
                }
                
                let url = '{{ route("empresas.credenciales") }}';
                url += '?sort_by=' + sortBy + '&sort_order=' + sortOrder;
                
                fetchResults(url);
            }
        });

        function verCredenciales(ruc) {
            $('#credencialesModal').modal('show');
            $('#loadingCredenciales').show();
            $('#infoCredenciales').hide();
            $('#errorCredenciales').hide();

            // Usar la ruta absoluta de Laravel para evitar problemas con subdirectorios
            const apiUrl = '{{ url("/api/empresas") }}/' + ruc;

            fetch(apiUrl, {
                headers: {
                    'X-API-KEY': '{{ $apiKeyValue }}',
                    'Content-Type': 'application/json'
                }
            })
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Network response was not ok');
                    }
                    return response.json();
                })
                .then(data => {
                    if (data.success) {
                        $('#modalRuc').text(data.data.ruc);
                        $('#modalRazonSocial').text(data.data.razon_social);
                        $('#modalSerie').text(data.data.serie || '-');
                        $('#modalUsuarioSol').val(data.data.usuario_sol || 'No registrado');
                        $('#modalClaveSol').val(data.data.clave_sol || 'No registrado');
                        $('#modalUsuarioSecundarioDni').val(data.data.usuario_secundario_dni || '-');
                        $('#modalUsuarioSecundarioUser').val(data.data.usuario_secundario_user || '-');
                        $('#modalUsuarioSecundarioClave').val(data.data.usuario_secundario_clave || '-');
                        $('#modalClaveCertificado').val(data.data.clave_certificado || '-');
                        
                        $('#loadingCredenciales').hide();
                        $('#infoCredenciales').show();
                    } else {
                        $('#loadingCredenciales').hide();
                        $('#errorCredenciales').text(data.message || 'Error al cargar datos').show();
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    $('#loadingCredenciales').hide();
                    $('#errorCredenciales').text('Error de conexión con la API').show();
                });
        }

        function copiarTexto(elementId) {
            var copyText = document.getElementById(elementId);
            copyText.select();
            copyText.setSelectionRange(0, 99999); /* For mobile devices */
            document.execCommand("copy");
            
            // Feedback visual (opcional)
            // alert("Copiado: " + copyText.value);
            // Podrías usar un tooltip o toast aquí
        }
    </script>
@endsection
