@extends('layouts.app')

@section('content')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Crear Nueva Empresa</h1>
        <a href="{{ route('empresas.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Volver
        </a>
    </div>

    <form method="POST" action="{{ route('empresas.store') }}">
        @csrf

        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h5>Información de la Empresa</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="ruc">RUC</label>
                                    <input type="text" class="form-control @error('ruc') is-invalid @enderror" id="ruc"
                                        name="ruc" value="{{ old('ruc') }}" required maxlength="11">
                                    @error('ruc')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="razon_social">Razón Social</label>
                                    <input type="text" class="form-control text-uppercase @error('razon_social') is-invalid @enderror" id="razon_social"
                                        name="razon_social" value="{{ old('razon_social') }}" required
                                        oninput="this.value = this.value.toUpperCase()">
                                    @error('razon_social')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="serie">Serie (3 dígitos)</label>
                                    <input type="text" class="form-control @error('serie') is-invalid @enderror" id="serie"
                                        name="serie" value="{{ old('serie') }}" maxlength="3" placeholder="001">
                                    @error('serie')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label for="nombre_comercial">Nombre Comercial (Opcional)</label>
                                    <input type="text" class="form-control text-uppercase @error('nombre_comercial') is-invalid @enderror" id="nombre_comercial"
                                        name="nombre_comercial" value="{{ old('nombre_comercial') }}"
                                        oninput="this.value = this.value.toUpperCase()">
                                    @error('nombre_comercial')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="sitio_web">Sitio Web (URL)</label>
                            <input type="url" class="form-control @error('sitio_web') is-invalid @enderror" id="sitio_web"
                                name="sitio_web" value="{{ old('sitio_web') }}" placeholder="https://www.ejemplo.com">
                            @error('sitio_web')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            @unless(auth()->user()->hasRole('operador'))
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="usuario_sol">Usuario SOL (Opcional)</label>
                                    <input type="text" class="form-control @error('usuario_sol') is-invalid @enderror" id="usuario_sol"
                                        name="usuario_sol" value="{{ old('usuario_sol') }}">
                                    @error('usuario_sol')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="clave_sol">Clave SOL (Opcional)</label>
                                    <input type="text" class="form-control @error('clave_sol') is-invalid @enderror" id="clave_sol"
                                        name="clave_sol" value="{{ old('clave_sol') }}">
                                    @error('clave_sol')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            @endunless
                        </div>

                        @unless(auth()->user()->hasRole('operador'))
                        <h6 class="mt-3">Usuario Secundario</h6>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="usuario_secundario_dni">DNI</label>
                                    <input type="text" class="form-control @error('usuario_secundario_dni') is-invalid @enderror" id="usuario_secundario_dni"
                                        name="usuario_secundario_dni" value="{{ old('usuario_secundario_dni') }}" maxlength="8">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="usuario_secundario_user">Usuario</label>
                                    <input type="text" class="form-control @error('usuario_secundario_user') is-invalid @enderror" id="usuario_secundario_user"
                                        name="usuario_secundario_user" value="{{ old('usuario_secundario_user') }}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="usuario_secundario_clave">Clave</label>
                                    <input type="text" class="form-control @error('usuario_secundario_clave') is-invalid @enderror" id="usuario_secundario_clave"
                                        name="usuario_secundario_clave" value="{{ old('usuario_secundario_clave') }}">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="clave_certificado">Clave del Certificado</label>
                            <input type="text" class="form-control @error('clave_certificado') is-invalid @enderror" id="clave_certificado"
                                name="clave_certificado" value="{{ old('clave_certificado') }}">
                        </div>
                        @endunless

                        <div class="form-group">
                            <label for="descripcion">Descripción</label>
                            <textarea class="form-control text-uppercase @error('descripcion') is-invalid @enderror" id="descripcion" name="descripcion"
                                rows="3" oninput="this.value = this.value.toUpperCase()">{{ old('descripcion') }}</textarea>
                            @error('descripcion')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        

                        @if(auth()->user()->hasRole('administrador'))
                            <div class="form-group mt-3">
                                <label class="font-weight-bold">Asignar Responsables</label>
                                <div class="card bg-light">
                                    <div class="card-body" style="max-height: 200px; overflow-y: auto;">
                                        @foreach($proveedores as $proveedor)
                                            <div class="custom-control custom-checkbox mb-2">
                                                <input type="checkbox" name="proveedores[]" 
                                                    class="custom-control-input" 
                                                    id="proveedor_{{ $proveedor->id }}" 
                                                    value="{{ $proveedor->id }}">
                                                <label class="custom-control-label" for="proveedor_{{ $proveedor->id }}">
                                                    {{ $proveedor->nombre_corto }}
                                                </label>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                                <small class="text-muted">Seleccione los responsables que tendrán acceso a esta empresa.</small>
                            </div>
                        @endif

                        <hr>
                        <h5>Tareas Iniciales (Opcional)</h5>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h5>Operadores Disponibles</h5>
                    </div>
                    <div class="card-body">
                        @foreach ($operadores as $operador)
                            <div class="mb-2">
                                <strong>{{ $operador->nombre_completo }}</strong><br>
                                <small class="text-muted">DNI: {{ $operador->dni }}</small>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5>Tareas de la Empresa</h5>
                <button type="button" class="btn btn-sm btn-success" id="agregarTarea">
                    <i class="fas fa-plus"></i> Agregar Tarea
                </button>
            </div>
            <div class="card-body">
                <div id="tareas-container">
                    <!-- Las tareas se agregan dinámicamente aquí -->
                </div>
            </div>
        </div>

        <div class="mt-4">
            <button type="submit" class="btn btn-primary">Crear Empresa</button>
            <a href="{{ route('empresas.index') }}" class="btn btn-secondary">Cancelar</a>
        </div>
    </form>
@endsection

@section('scripts')
    <script>
        let tareaIndex = 0;

        function agregarTarea() {
            const container = document.getElementById('tareas-container');
            const tareaHtml = `
        <div class="tarea-item border rounded p-3 mb-3" data-index="${tareaIndex}">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h6>Tarea ${tareaIndex + 1}</h6>
                <button type="button" class="btn btn-sm btn-danger" onclick="eliminarTarea(${tareaIndex})">
                    <i class="fas fa-trash"></i>
                </button>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Título de la Tarea</label>
                        <input type="text" class="form-control text-uppercase" name="tareas[${tareaIndex}][titulo]" required oninput="this.value = this.value.toUpperCase()">
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Prioridad</label>
                        <select class="form-control" name="tareas[${tareaIndex}][prioridad]" required>
                            <option value="baja">Baja</option>
                            <option value="media" selected>Media</option>
                            <option value="alta">Alta</option>
                            <option value="urgente">Urgente</option>
                        </select>
                    </div>
                </div>
            </div>
            
            <div class="form-group">
                <label>Descripción</label>
                <textarea class="form-control text-uppercase" name="tareas[${tareaIndex}][descripcion]" rows="2" required oninput="this.value = this.value.toUpperCase()"></textarea>
            </div>
            
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Fecha Inicio Estimada</label>
                        <input type="date" class="form-control" name="tareas[${tareaIndex}][fecha_inicio_estimada]" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Fecha Fin Estimada</label>
                        <input type="date" class="form-control" name="tareas[${tareaIndex}][fecha_fin_estimada]" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Operador Asignado</label>
                        <select class="form-control" name="tareas[${tareaIndex}][operador_id]" required>
                            <option value="">Seleccionar operador</option>
                            @foreach ($operadores as $operador)
                                <option value="{{ $operador->id }}">{{ $operador->nombre_completo }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
        </div>
    `;

            container.insertAdjacentHTML('beforeend', tareaHtml);
            tareaIndex++;
        }

        function eliminarTarea(index) {
            const tarea = document.querySelector(`[data-index="${index}"]`);
            if (tarea) {
                tarea.remove();
            }
        }

        document.getElementById('agregarTarea').addEventListener('click', agregarTarea);

        // Agregar al menos una tarea al cargar la página
        document.addEventListener('DOMContentLoaded', function() {
            agregarTarea();
        });
    </script>
@endsection
