@extends('layouts.app')

@section('content')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Agregar Tareas a: {{ $empresa->razon_social }}</h1>
        <a href="{{ route('empresas.show', $empresa) }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Volver a la Empresa
        </a>
    </div>

    <form method="POST" action="{{ route('empresas.store-tareas', $empresa) }}">
        @csrf

        <div class="row">
            <div class="col-md-8">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5>Información de la Empresa</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <strong>Empresa:</strong> {{ $empresa->razon_social }}<br>
                                <strong>RUC:</strong> {{ $empresa->ruc }}<br>
                                <strong>Estado:</strong>
                                <span class="badge badge-success">{{ ucfirst($empresa->estado) }}</span><br>
                                <strong>Tareas actuales:</strong> {{ $empresa->tareas->count() }}<br>
                            </div>
                            <div class="col-md-6">
                                <strong>Responsables:</strong>
                                @foreach($empresa->proveedores as $proveedor)
                                    {{ $proveedor->nombre_corto }}@if(!$loop->last), @endif
                                @endforeach
                                <br>
                                <strong>Fecha creación:</strong> {{ $empresa->created_at->format('d/m/Y') }}<br>
                                <strong>Último orden:</strong> {{ $ultimoOrden }}<br>

                                @if (auth()->user()->hasRole('proveedor'))
                                    <div class="alert alert-info mt-2">
                                        <small><i class="fas fa-info-circle"></i> Puedes agregar más tareas a tu empresa
                                            aprobada.</small>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h5>Operadores Disponibles</h5>
                    </div>
                    <div class="card-body">
                        @foreach ($operadores as $operador)
                            <div class="mb-2">
                                <strong>{{ $operador->nombre_completo }}</strong><br>
                                <small class="text-muted">ID: {{ $operador->id }} | DNI: {{ $operador->dni }}</small>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5>Nuevas Tareas</h5>
                <button type="button" class="btn btn-sm btn-success" id="agregarTarea">
                    <i class="fas fa-plus"></i> Agregar Tarea
                </button>
            </div>
            <div class="card-body">
                <div id="tareas-container">
                    <!-- Las tareas se agregan dinámicamente aquí -->
                </div>

                <div class="alert alert-info">
                    <i class="fas fa-info-circle"></i>
                    <strong>Nota:</strong> Las nuevas tareas se agregarán al final de la lista actual.
                    La última tarea tiene orden {{ $ultimoOrden }}, las nuevas comenzarán desde
                    {{ $ultimoOrden + 1 }}.
                </div>
            </div>
        </div>

        <div class="mt-4">
            <button type="submit" class="btn btn-primary" id="submitBtn" style="display: none;">
                <i class="fas fa-save"></i> Agregar Tareas a la Empresa
            </button>
            <a href="{{ route('empresas.show', $empresa) }}" class="btn btn-secondary">Cancelar</a>
        </div>
    </form>
@endsection

@section('scripts')
    <script>
        let tareaIndex = 0;
        let ultimoOrden = {{ $ultimoOrden }};

        function agregarTarea() {
            const container = document.getElementById('tareas-container');
            const nuevoOrden = ultimoOrden + tareaIndex + 1;

            const tareaHtml = `
        <div class="tarea-item border rounded p-3 mb-3" data-index="${tareaIndex}">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h6>Tarea ${nuevoOrden} (Nueva)</h6>
                <button type="button" class="btn btn-sm btn-danger" onclick="eliminarTarea(${tareaIndex})">
                    <i class="fas fa-trash"></i> Eliminar
                </button>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Título de la Tarea</label>
                        <input type="text" class="form-control" name="tareas[${tareaIndex}][titulo]" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Prioridad</label>
                        <select class="form-control" name="tareas[${tareaIndex}][prioridad]" required>
                            <option value="baja">Baja</option>
                            <option value="media" selected>Media</option>
                            <option value="alta">Alta</option>
                            <option value="urgente">Urgente</option>
                        </select>
                    </div>
                </div>
            </div>
            
            <div class="form-group">
                <label>Descripción</label>
                <textarea class="form-control" name="tareas[${tareaIndex}][descripcion]" rows="2" required></textarea>
            </div>
            
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Fecha Inicio Estimada</label>
                        <input type="date" class="form-control" name="tareas[${tareaIndex}][fecha_inicio_estimada]" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Fecha Fin Estimada</label>
                        <input type="date" class="form-control" name="tareas[${tareaIndex}][fecha_fin_estimada]" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Operador Asignado</label>
                        <select class="form-control" name="tareas[${tareaIndex}][operador_id]" required>
                            <option value="">Seleccionar operador</option>
                            @foreach ($operadores as $operador)
                                <option value="{{ $operador->id }}">{{ $operador->nombre_completo }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
        </div>
    `;

            container.insertAdjacentHTML('beforeend', tareaHtml);
            tareaIndex++;

            // Mostrar botón de submit si hay tareas
            document.getElementById('submitBtn').style.display = 'inline-block';
        }

        function eliminarTarea(index) {
            const tarea = document.querySelector(`[data-index="${index}"]`);
            if (tarea) {
                tarea.remove();

                // Ocultar botón si no hay tareas
                const tareasRestantes = document.querySelectorAll('.tarea-item');
                if (tareasRestantes.length === 0) {
                    document.getElementById('submitBtn').style.display = 'none';
                }
            }
        }

        document.getElementById('agregarTarea').addEventListener('click', agregarTarea);

        // Validación de formulario
        document.querySelector('form').addEventListener('submit', function(e) {
            const tareas = document.querySelectorAll('.tarea-item');
            if (tareas.length === 0) {
                e.preventDefault();
                alert('Debes agregar al menos una tarea.');
                return false;
            }
        });
    </script>
@endsection
