@component('mail::message')
# Nueva Tarea Asignada

Hola {{ $tarea->operador->nombre_corto }},

Se te ha asignado una nueva tarea en el sistema.

**Título:** {{ $tarea->titulo }}  
**Empresa:** {{ $tarea->empresa->nombre_comercial ?? $tarea->empresa->razon_social }}  
**Prioridad:** {{ ucfirst($tarea->prioridad) }}  
**Fecha Vencimiento:** {{ $tarea->fecha_fin_estimada->format('d/m/Y') }}

**Descripción:**  
{{ Str::limit($tarea->descripcion, 200) }}

@component('mail::button', ['url' => route('tareas.show', $tarea)])
Ver Tarea
@endcomponent

Atentamente,<br>
{{ config('app.name') }}
@endcomponent
