@extends('layouts.app')

@section('content')
<style>
    body {
        background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    #app {
        width: 100%;
    }
    .login-card {
        border: none;
        border-radius: 15px;
        box-shadow: 0 10px 25px rgba(0,0,0,0.2);
        overflow: hidden;
    }
    .login-header {
        background: #fff;
        padding: 30px 20px 10px;
        text-align: center;
        border-bottom: none;
    }
    .login-header h4 {
        color: #1e3c72;
        font-weight: 700;
        margin-top: 10px;
    }
    .login-icon {
        background: #eef2f7;
        width: 80px;
        height: 80px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto;
        color: #1e3c72;
        font-size: 32px;
    }
    .login-body {
        padding: 20px 40px 40px;
    }
    .form-control {
        border-radius: 50px;
        padding: 10px 20px;
        height: 45px;
        background-color: #f8f9fa;
        border: 1px solid #e9ecef;
    }
    .form-control:focus {
        box-shadow: none;
        border-color: #1e3c72;
        background-color: #fff;
    }
    .btn-login {
        border-radius: 50px;
        padding: 10px 20px;
        font-weight: 600;
        letter-spacing: 0.5px;
        background: linear-gradient(to right, #1e3c72, #2a5298);
        border: none;
        transition: all 0.3s ease;
    }
    .btn-login:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(30, 60, 114, 0.3);
        background: linear-gradient(to right, #162b52, #203e72);
    }
    .form-group label {
        font-weight: 600;
        color: #555;
        font-size: 0.9rem;
        margin-left: 10px;
    }
    .input-group-text {
        border-radius: 50px 0 0 50px;
        background: #f8f9fa;
        border: 1px solid #e9ecef;
        border-right: none;
        color: #1e3c72;
    }
    .form-control-with-icon {
        border-radius: 0 50px 50px 0;
        border-left: none;
    }
    .forgot-password {
        color: #6c757d;
        font-size: 0.9rem;
        text-decoration: none;
        transition: color 0.3s;
    }
    .forgot-password:hover {
        color: #1e3c72;
        text-decoration: none;
    }
</style>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-5 col-lg-4">
            <div class="card login-card">
                <div class="card-header login-header">
                    <div class="login-icon">
                        <i class="fas fa-user-shield"></i>
                    </div>
                    <h4>Bienvenido</h4>
                    <p class="text-muted small">Ingresa tus credenciales para continuar</p>
                </div>
                <div class="card-body login-body">
                    <form method="POST" action="{{ route('login') }}">
                        @csrf

                        <div class="form-group mb-4">
                            <label for="login">Usuario o Email</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text pl-3"><i class="fas fa-user"></i></span>
                                </div>
                                <input id="login" type="text" class="form-control form-control-with-icon @error('login') is-invalid @enderror"
                                    name="login" value="{{ old('login') }}" required autofocus placeholder="Ej. usuario@empresa.com">
                            </div>
                            @error('login')
                                <span class="invalid-feedback d-block ml-3" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group mb-4">
                            <label for="password">Contraseña</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text pl-3"><i class="fas fa-lock"></i></span>
                                </div>
                                <input id="password" type="password"
                                    class="form-control form-control-with-icon @error('password') is-invalid @enderror" name="password" required placeholder="••••••••">
                            </div>
                            @error('password')
                                <span class="invalid-feedback d-block ml-3" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group d-flex justify-content-between align-items-center mb-4">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                                <label class="custom-control-label small" for="remember">Recordarme</label>
                            </div>
                            @if (Route::has('password.request'))
                                <a class="forgot-password" href="{{ route('password.request') }}">
                                    ¿Olvidaste tu contraseña?
                                </a>
                            @endif
                        </div>

                        <button type="submit" class="btn btn-primary btn-block btn-login text-white mb-3">
                            INGRESAR
                        </button>
                    </form>
                </div>
            </div>
            <div class="text-center mt-3 text-white-50 small">
                &copy; {{ date('Y') }} {{ config('app.name', 'Gestion Tareas') }}. Todos los derechos reservados.
            </div>
        </div>
    </div>
</div>
@endsection
