@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Registro de Terminales Anydesk</h1>
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#terminalModal" onclick="openCreateModal()">
            <i class="fas fa-plus"></i> Nuevo Terminal
        </button>
    </div>

    <div class="row mb-3">
        <div class="col-md-6">
            <form action="{{ route('admin.anydesk.index') }}" method="GET" class="d-flex">
                <input type="text" name="search" class="form-control mr-2" placeholder="Buscar por Nombre, ID o Empresa" value="{{ request('search') }}">
                <button type="submit" class="btn btn-outline-primary">Buscar</button>
                @if(request('search'))
                    <a href="{{ route('admin.anydesk.index') }}" class="btn btn-outline-secondary ml-2">Limpiar</a>
                @endif
            </form>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="row">
        @forelse($terminals as $terminal)
            <div class="col-md-4 mb-4">
                <div class="card h-100 shadow-sm">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0 text-truncate" title="{{ $terminal->nombre }}">{{ $terminal->nombre }}</h5>
                        <div class="dropdown">
                            <button class="btn btn-link text-muted p-0" type="button" data-toggle="dropdown">
                                <i class="fas fa-ellipsis-v"></i>
                            </button>
                            <div class="dropdown-menu dropdown-menu-right">
                                <button class="dropdown-item" onclick='openEditModal(@json($terminal))'>
                                    <i class="fas fa-edit mr-2"></i> Editar
                                </button>
                                <form action="{{ route('admin.anydesk.destroy', $terminal) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="dropdown-item text-danger" onclick="return confirm('¿Estás seguro de eliminar este terminal?')">
                                        <i class="fas fa-trash mr-2"></i> Eliminar
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group mb-2">
                            <label class="small text-muted mb-0">ID de Trabajo</label>
                            <div class="input-group input-group-sm">
                                <input type="text" class="form-control bg-light" value="{{ $terminal->id_trabajo }}" readonly id="id-{{ $terminal->id }}">
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard('id-{{ $terminal->id }}')" title="Copiar ID">
                                        <i class="fas fa-copy"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group mb-2">
                            <label class="small text-muted mb-0">Clave</label>
                            <div class="input-group input-group-sm">
                                <input type="text" class="form-control bg-light" value="{{ $terminal->clave ?? 'N/A' }}" readonly id="clave-{{ $terminal->id }}">
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard('clave-{{ $terminal->id }}')" title="Copiar Clave" {{ !$terminal->clave ? 'disabled' : '' }}>
                                        <i class="fas fa-copy"></i>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="mt-3">
                            <label class="small text-muted mb-0">Empresa Asignada</label>
                            @if($terminal->empresa)
                                <div class="d-flex align-items-center text-primary">
                                    <i class="fas fa-building mr-2"></i>
                                    <span class="font-weight-bold">{{ $terminal->empresa->nombre_comercial ?? $terminal->empresa->razon_social }}</span>
                                </div>
                            @else
                                <div class="text-muted font-italic">
                                    <i class="fas fa-unlink mr-2"></i> Sin asignar
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-12">
                <div class="alert alert-info text-center">
                    No se encontraron terminales registrados.
                </div>
            </div>
        @endforelse
    </div>

    <div class="d-flex justify-content-center mt-4">
        {{ $terminals->withQueryString()->links() }}
    </div>
</div>

<!-- Modal Create/Edit -->
<div class="modal fade" id="terminalModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalTitle">Nuevo Terminal</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="terminalForm" method="POST">
                @csrf
                <div id="methodField"></div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="nombre">Nombre del Terminal <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="nombre" name="nombre" required>
                    </div>
                    <div class="form-group">
                        <label for="id_trabajo">ID de Trabajo <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="id_trabajo" name="id_trabajo" required>
                    </div>
                    <div class="form-group">
                        <label for="clave">Clave (Opcional)</label>
                        <input type="text" class="form-control" id="clave" name="clave">
                    </div>
                    <div class="form-group">
                        <label for="empresa_id">Asignar a Empresa</label>
                        <select class="form-control" id="empresa_id" name="empresa_id">
                            <option value="">-- Sin Asignar --</option>
                            @foreach($empresas as $empresa)
                                <option value="{{ $empresa->id }}">
                                    {{ $empresa->nombre_comercial ?? $empresa->razon_social }} ({{ $empresa->ruc }})
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
    function copyToClipboard(elementId) {
        var copyText = document.getElementById(elementId);
        copyText.select();
        copyText.setSelectionRange(0, 99999); /* For mobile devices */
        document.execCommand("copy");
        
        // Optional: Show tooltip or toast
        // alert("Copiado: " + copyText.value);
        
        // Visual feedback
        var btn = copyText.nextElementSibling.querySelector('button');
        var originalHtml = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-check"></i>';
        btn.classList.remove('btn-outline-secondary');
        btn.classList.add('btn-success');
        
        setTimeout(function() {
            btn.innerHTML = originalHtml;
            btn.classList.remove('btn-success');
            btn.classList.add('btn-outline-secondary');
        }, 1500);
    }

    function openCreateModal() {
        document.getElementById('modalTitle').innerText = 'Nuevo Terminal';
        document.getElementById('terminalForm').action = "{{ route('admin.anydesk.store') }}";
        document.getElementById('methodField').innerHTML = '';
        
        document.getElementById('nombre').value = '';
        document.getElementById('id_trabajo').value = '';
        document.getElementById('clave').value = '';
        document.getElementById('empresa_id').value = '';
    }

    function openEditModal(terminal) {
        document.getElementById('modalTitle').innerText = 'Editar Terminal';
        var actionUrl = "{{ route('admin.anydesk.update', ':id') }}";
        actionUrl = actionUrl.replace(':id', terminal.id);
        document.getElementById('terminalForm').action = actionUrl;
        document.getElementById('methodField').innerHTML = '@method("PUT")';
        
        document.getElementById('nombre').value = terminal.nombre;
        document.getElementById('id_trabajo').value = terminal.id_trabajo;
        document.getElementById('clave').value = terminal.clave || '';
        document.getElementById('empresa_id').value = terminal.empresa_id || '';
        
        $('#terminalModal').modal('show');
    }
</script>
@endsection
