<!-- resources/views/admin/users/index.blade.php -->
@extends('layouts.app')

@section('content')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Gestión de Usuarios</h1>
        <div>
            <a href="{{ route('admin.users.index') }}" class="btn btn-outline-secondary mr-2">
                <i class="fas fa-sync-alt"></i> Actualizar
            </a>
            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#createUserModal">
                <i class="fas fa-user-plus"></i> Nuevo Usuario
            </button>
        </div>
    </div>

    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <strong>¡Atención!</strong> Por favor verifica los errores en el formulario.
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'username', 'direction' => request('sort') == 'username' && request('direction') == 'asc' ? 'desc' : 'asc']) }}" class="text-dark">
                                    Usuario
                                    @if(request('sort') == 'username')
                                        <i class="fas fa-sort-{{ request('direction') == 'asc' ? 'up' : 'down' }}"></i>
                                    @else
                                        <i class="fas fa-sort text-muted" style="opacity: 0.3;"></i>
                                    @endif
                                </a>
                            </th>
                            <th>
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'dni', 'direction' => request('sort') == 'dni' && request('direction') == 'asc' ? 'desc' : 'asc']) }}" class="text-dark">
                                    DNI
                                    @if(request('sort') == 'dni')
                                        <i class="fas fa-sort-{{ request('direction') == 'asc' ? 'up' : 'down' }}"></i>
                                    @else
                                        <i class="fas fa-sort text-muted" style="opacity: 0.3;"></i>
                                    @endif
                                </a>
                            </th>
                            <th>
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'nombre', 'direction' => request('sort') == 'nombre' && request('direction') == 'asc' ? 'desc' : 'asc']) }}" class="text-dark">
                                    Nombre Completo
                                    @if(request('sort') == 'nombre')
                                        <i class="fas fa-sort-{{ request('direction') == 'asc' ? 'up' : 'down' }}"></i>
                                    @else
                                        <i class="fas fa-sort text-muted" style="opacity: 0.3;"></i>
                                    @endif
                                </a>
                            </th>
                            <th>
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'email', 'direction' => request('sort') == 'email' && request('direction') == 'asc' ? 'desc' : 'asc']) }}" class="text-dark">
                                    Email
                                    @if(request('sort') == 'email')
                                        <i class="fas fa-sort-{{ request('direction') == 'asc' ? 'up' : 'down' }}"></i>
                                    @else
                                        <i class="fas fa-sort text-muted" style="opacity: 0.3;"></i>
                                    @endif
                                </a>
                            </th>
                            <th>Rol</th>
                            <th>
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'estado', 'direction' => request('sort') == 'estado' && request('direction') == 'asc' ? 'desc' : 'asc']) }}" class="text-dark">
                                    Estado
                                    @if(request('sort') == 'estado')
                                        <i class="fas fa-sort-{{ request('direction') == 'asc' ? 'up' : 'down' }}"></i>
                                    @else
                                        <i class="fas fa-sort text-muted" style="opacity: 0.3;"></i>
                                    @endif
                                </a>
                            </th>
                            <th>
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'created_at', 'direction' => request('sort') == 'created_at' && request('direction') == 'asc' ? 'desc' : 'asc']) }}" class="text-dark">
                                    Fecha Registro
                                    @if(request('sort') == 'created_at')
                                        <i class="fas fa-sort-{{ request('direction') == 'asc' ? 'up' : 'down' }}"></i>
                                    @else
                                        <i class="fas fa-sort text-muted" style="opacity: 0.3;"></i>
                                    @endif
                                </a>
                            </th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($users as $user)
                            <tr>
                                <td>{{ $user->username }}</td>
                                <td>{{ $user->dni }}</td>
                                <td>{{ $user->nombre_completo }}</td>
                                <td>{{ $user->email }}</td>
                                <td>
                                    @foreach ($user->roles as $role)
                                        <span class="badge badge-info">{{ $role->name }}</span>
                                    @endforeach
                                </td>
                                <td>
                                    <form action="{{ route('admin.users.toggle-status', $user) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('PATCH')
                                        <button type="submit" class="badge badge-{{ $user->estado === 'activo' ? 'success' : 'danger' }} border-0"
                                            style="cursor: pointer;" title="Clic para cambiar estado">
                                            {{ ucfirst($user->estado) }}
                                        </button>
                                    </form>
                                </td>
                                <td>{{ $user->created_at->format('d/m/Y') }}</td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-outline-primary btn-edit-user"
                                        data-id="{{ $user->id }}"
                                        data-nombre="{{ $user->nombre }}"
                                        data-apellidos="{{ $user->apellidos }}"
                                        data-dni="{{ $user->dni }}"
                                        data-email="{{ $user->email }}"
                                        data-username="{{ $user->username }}"
                                        data-role="{{ $user->roles->first()->name ?? '' }}"
                                        data-estado="{{ $user->estado }}"
                                        data-toggle="modal" data-target="#editUserModal">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    @if ($user->id != auth()->user()->id)
                                        <form method="POST" action="{{ route('admin.users.destroy', $user) }}"
                                            class="d-inline" onsubmit="return confirm('¿Estás seguro?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-center">
                {{ $users->appends(request()->query())->links() }}
            </div>
        </div>
    </div>

    <!-- Modal Crear Usuario -->
    <div class="modal fade" id="createUserModal" tabindex="-1" role="dialog" aria-labelledby="createUserModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="createUserModalLabel">Crear Nuevo Usuario</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="POST" action="{{ route('admin.users.store') }}">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="create_nombre">Nombre</label>
                                    <input type="text" class="form-control @error('nombre') is-invalid @enderror"
                                        id="create_nombre" name="nombre" value="{{ old('nombre') }}" required>
                                    @error('nombre')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="create_apellidos">Apellidos</label>
                                    <input type="text" class="form-control @error('apellidos') is-invalid @enderror"
                                        id="create_apellidos" name="apellidos" value="{{ old('apellidos') }}" required>
                                    @error('apellidos')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="create_dni">DNI</label>
                                    <input type="text" class="form-control @error('dni') is-invalid @enderror"
                                        id="create_dni" name="dni" value="{{ old('dni') }}" required maxlength="8">
                                    @error('dni')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="create_role">Rol</label>
                                    <select class="form-control @error('role') is-invalid @enderror" id="create_role"
                                        name="role" required>
                                        <option value="">Seleccionar rol</option>
                                        @foreach ($roles as $role)
                                            <option value="{{ $role->name }}"
                                                {{ old('role') === $role->name ? 'selected' : '' }}>
                                                {{ ucfirst($role->name) }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('role')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="create_username">Usuario</label>
                                    <input type="text" class="form-control @error('username') is-invalid @enderror"
                                        id="create_username" name="username" value="{{ old('username') }}" required>
                                    @error('username')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="create_email">Email</label>
                                    <input type="email" class="form-control @error('email') is-invalid @enderror"
                                        id="create_email" name="email" value="{{ old('email') }}" required>
                                    @error('email')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="create_password">Contraseña</label>
                                    <input type="password" class="form-control @error('password') is-invalid @enderror"
                                        id="create_password" name="password" required>
                                    @error('password')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="create_password_confirmation">Confirmar Contraseña</label>
                                    <input type="password" class="form-control" id="create_password_confirmation"
                                        name="password_confirmation" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Guardar Usuario</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Editar Usuario -->
    <div class="modal fade" id="editUserModal" tabindex="-1" role="dialog" aria-labelledby="editUserModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editUserModalLabel">Editar Usuario</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="editUserForm" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit_nombre">Nombre</label>
                                    <input type="text" class="form-control" id="edit_nombre" name="nombre" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit_apellidos">Apellidos</label>
                                    <input type="text" class="form-control" id="edit_apellidos" name="apellidos"
                                        required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit_email">Email</label>
                                    <input type="email" class="form-control @error('email') is-invalid @enderror"
                                        id="edit_email" name="email" value="{{ old('email') }}" required>
                                    @error('email')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit_dni">DNI</label>
                                    <input type="text" class="form-control @error('dni') is-invalid @enderror"
                                        id="edit_dni" name="dni" value="{{ old('dni') }}" required maxlength="8">
                                    @error('dni')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit_role">Rol</label>
                                    <select class="form-control" id="edit_role" name="role" required>
                                        <option value="">Seleccionar rol</option>
                                        @foreach ($roles as $role)
                                            <option value="{{ $role->name }}">{{ ucfirst($role->name) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div> 
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit_username">Usuario</label>
                                    <input type="text" class="form-control @error('username') is-invalid @enderror"
                                        id="edit_username" name="username" value="{{ old('username') }}" required>
                                    @error('username')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            {{-- <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit_estado">Estado</label>
                                    <select class="form-control" id="edit_estado" name="estado" required>
                                        <option value="activo">Activo</option>
                                        <option value="inactivo">Inactivo</option>
                                    </select>
                                </div>
                            </div> --}}
                        </div>

                        <hr>
                        <h6 class="text-muted">Cambiar Contraseña (Opcional)</h6>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit_password">Nueva Contraseña</label>
                                    <input type="password" class="form-control" id="edit_password" name="password">
                                    <small class="text-muted">Dejar en blanco para mantener la actual</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit_password_confirmation">Confirmar Nueva Contraseña</label>
                                    <input type="password" class="form-control" id="edit_password_confirmation"
                                        name="password_confirmation">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Actualizar Usuario</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            // Manejar apertura del modal de edición
            $('.btn-edit-user').click(function() {
                var btn = $(this);
                var id = btn.data('id');
                var nombre = btn.data('nombre');
                var apellidos = btn.data('apellidos');
                var email = btn.data('email');
                var username = btn.data('username');
                var dni = btn.data('dni');
                var email = btn.data('email');
                var role = btn.data('role');
                var estado = btn.data('estado');

                // Actualizar action del formulario
                var url = "{{ route('admin.users.update', ':id') }}";
                url = url.replace(':id', id);
                $('#editUserForm').attr('action', url);

                // Llenar campos
                $('#edit_user_id').val(id);
                $('#edit_nombre').val(nombre);
                $('#edit_apellidos').val(apellidos);
                $('#edit_email').val(email);
                $('#edit_username').val(username);
                $('#edit_dni').val(dni);
                $('#edit_email').val(email);
                $('#edit_role').val(role);
                $('#edit_estado').val(estado);
            });

            // Re-abrir modal si hay errores
            @if ($errors->any())
                // Si NO es edición (create), abrir modal create
                @if (!old('_method'))
                    $('#createUserModal').modal('show');
                @endif
                
                // Si hay error en 'edit' (detectado por _method PUT)
                @if (old('_method') == 'PUT' && old('user_id'))
                    var id = "{{ old('user_id') }}";
                    var url = "{{ route('admin.users.update', ':id') }}";
                    url = url.replace(':id', id);
                    $('#editUserForm').attr('action', url);
                    $('#editUserModal').modal('show');
                @endif
            @endif
        });
    </script>
@endsection
