<!-- resources/views/admin/dashboard.blade.php -->
@extends('layouts.app')

@section('content')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Dashboard Administrador</h1>
    </div>

    <!-- Estadísticas -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card text-white bg-primary">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h5 class="card-title">{{ $stats['usuarios_total'] }}</h5>
                            <p class="card-text">Usuarios Total</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-users fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card text-white bg-warning">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h5 class="card-title">{{ $stats['empresas_pendientes'] }}</h5>
                            <p class="card-text">Empresas Pendientes</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-building fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card text-white bg-info">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h5 class="card-title">{{ $stats['tareas_en_progreso'] }}</h5>
                            <p class="card-text">Tareas en Progreso</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-spinner fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card text-white bg-success">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h5 class="card-title">{{ $stats['tareas_finalizadas'] }}</h5>
                            <p class="card-text">Tareas Finalizadas</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-check-circle fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Empresas Pendientes -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5>Empresas Pendientes de Aprobación</h5>
                </div>
                <div class="card-body">
                    @if ($empresasPendientes->count() > 0)
                        @foreach ($empresasPendientes as $empresa)
                            <div class="border-bottom pb-2 mb-2">
                                <h6><a href="{{ route('empresas.show', $empresa) }}">{{ $empresa->nombre_comercial ?? $empresa->razon_social }}</a></h6>
                                <small class="text-muted">RUC: {{ $empresa->ruc }}</small>
                                <small class="text-muted">| Por: 
                                    @foreach($empresa->proveedores as $proveedor)
                                        {{ $proveedor->nombre_corto }}@if(!$loop->last), @endif
                                    @endforeach
                                </small>
                                <small class="text-muted">| {{ $empresa->created_at->diffForHumans() }}</small>
                            </div>
                        @endforeach
                        <a href="{{ route('empresas.index') }}" class="btn btn-sm btn-primary">Ver todas</a>
                    @else
                        <p class="text-muted">No hay empresas pendientes.</p>
                    @endif
                </div>
            </div>
        </div>

        <!-- Tareas Urgentes -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5>Tareas Urgentes</h5>
                </div>
                <div class="card-body">
                    @if ($tareasUrgentes->count() > 0)
                        @foreach ($tareasUrgentes as $tarea)
                            <div class="border-bottom pb-2 mb-2">
                                <h6><a href="{{ route('tareas.show', $tarea) }}">{{ $tarea->titulo }}</a></h6>
                                <small class="text-muted">Empresa: {{ $tarea->empresa->razon_social }}</small>
                                <br>
                                <small class="text-muted">Operador: {{ $tarea->operador ? $tarea->operador->nombre_completo : 'Sin asignar' }}</small>
                                <span class="badge badge-{{ $tarea->estado_color }}">{{ $tarea->estado }}</span>
                            </div>
                        @endforeach
                        <a href="{{ route('tareas.index') }}" class="btn btn-sm btn-primary">Ver todas</a>
                    @else
                        <p class="text-muted">No hay tareas urgentes.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Actividad Reciente -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5>Actividad Reciente</h5>
                </div>
                <div class="card-body">
                    @if ($actividadReciente->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Usuario</th>
                                        <th>Acción</th>
                                        <th>Tabla</th>
                                        <th>Fecha</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($actividadReciente as $auditoria)
                                        <tr>
                                            <td>{{ $auditoria->user->nombre_completo }}</td>
                                            <td>{{ $auditoria->accion }}</td>
                                            <td>{{ $auditoria->tabla_afectada }}</td>
                                            <td>{{ $auditoria->created_at->diffForHumans() }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="text-muted">No hay actividad reciente.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
