@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Gestión de API Keys</h1>
    </div>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header bg-dark text-white">
                    API Key Actual
                </div>
                <div class="card-body">
                    @if($currentKey)
                        <div class="form-group">
                            <label class="font-weight-bold">Clave Actual:</label>
                            <div class="input-group">
                                <input type="text" class="form-control form-control-lg text-monospace" value="{{ $currentKey->key }}" readonly id="apiKeyInput">
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard()">
                                        <i class="fas fa-copy"></i> Copiar
                                    </button>
                                </div>
                            </div>
                            <small class="text-muted">Estado: 
                                <span class="badge badge-success">Activa</span>
                            </small>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="font-weight-bold">Fecha de Creación:</label>
                                    <p>{{ $currentKey->created_at->format('d/m/Y H:i:s') }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="font-weight-bold text-danger">Fecha de Expiración:</label>
                                    <p class="text-danger font-weight-bold">
                                        {{ $currentKey->expires_at ? $currentKey->expires_at->format('d/m/Y H:i:s') : 'Nunca' }}
                                        ({{ $currentKey->expires_at ? $currentKey->expires_at->diffForHumans() : '' }})
                                    </p>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i> No hay una API Key activa actualmente. El sistema puede no funcionar correctamente.
                        </div>
                    @endif

                    <hr>

                    <h5 class="card-title mt-4">Generar Nueva Llave</h5>
                    <p class="card-text text-muted">Generar una nueva llave invalidará inmediatamente la anterior.</p>
                    
                    <form action="{{ route('admin.api-keys.regenerate') }}" method="POST" onsubmit="return confirm('¿Estás seguro? La llave anterior dejará de funcionar inmediatamente.');">
                        @csrf
                        <div class="form-group">
                            <label for="duration">Duración de la nueva llave:</label>
                            <select name="duration" id="duration" class="form-control" style="max-width: 200px;">
                                <option value="1" selected>1 Mes</option>
                                <option value="3">3 Meses</option>
                                <option value="6">6 Meses</option>
                                <option value="12">1 Año</option>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-sync-alt"></i> Regenerar Llave
                        </button>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card bg-light">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-info-circle"></i> Información</h5>
                    <p class="card-text">
                        La API Key se utiliza para autenticar las peticiones a la API de consulta de empresas desde el frontend.
                    </p>
                    <p class="card-text">
                        <strong>Seguridad:</strong>
                        <ul>
                            <li>Mantenga esta llave segura.</li>
                            <li>Si sospecha que ha sido comprometida, regenérela inmediatamente.</li>
                            <li>La llave expira automáticamente según el tiempo configurado.</li>
                        </ul>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function copyToClipboard() {
    var copyText = document.getElementById("apiKeyInput");
    copyText.select();
    copyText.setSelectionRange(0, 99999);
    document.execCommand("copy");
    alert("API Key copiada al portapapeles");
}
</script>
@endsection
