/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Alexander Akait @alexander-akait
*/

"use strict";

/**
 * @type {Readonly<"javascript">}
 */
const JAVASCRIPT_TYPE = "javascript";

/**
 * @type {Readonly<"runtime">}
 */
const RUNTIME_TYPE = "runtime";

/**
 * @type {Readonly<"webassembly">}
 */
const WEBASSEMBLY_TYPE = "webassembly";

/**
 * @type {Readonly<"asset">}
 */
const ASSET_TYPE = "asset";

/**
 * @type {Readonly<"css">}
 */
const CSS_TYPE = "css";

/**
 * @type {Readonly<"css-import">}
 */
const CSS_IMPORT_TYPE = "css-import";

/**
 * @type {Readonly<"css-url">}
 */
const CSS_URL_TYPE = "css-url";

/**
 * @type {Readonly<"share-init">}
 */
const SHARED_INIT_TYPE = "share-init";

/**
 * @type {Readonly<"remote">}
 */
const REMOTE_GENERATOR_TYPE = "remote";

/**
 * @type {Readonly<"consume-shared">}
 */
const CONSUME_SHARED_GENERATOR_TYPE = "consume-shared";

/**
 * @type {Readonly<"unknown">}
 */
const UNKNOWN_TYPE = "unknown";

/**
 * @typedef {JAVASCRIPT_TYPE |
 * RUNTIME_TYPE |
 * WEBASSEMBLY_TYPE |
 * ASSET_TYPE |
 * CSS_TYPE |
 * CSS_IMPORT_TYPE |
 * CSS_URL_TYPE |
 * SHARED_INIT_TYPE |
 * REMOTE_GENERATOR_TYPE |
 * CONSUME_SHARED_GENERATOR_TYPE |
 * UNKNOWN_TYPE} AllTypes
 */

/**
 * @type {ReadonlySet<never>}
 */
const NO_TYPES = new Set();

/**
 * @type {ReadonlySet<"asset">}
 */
const ASSET_TYPES = new Set([ASSET_TYPE]);

/**
 * @type {ReadonlySet<"asset" | "javascript" | "asset">}
 */
const ASSET_AND_JAVASCRIPT_TYPES = new Set([ASSET_TYPE, JAVASCRIPT_TYPE]);

/**
 * @type {ReadonlySet<"css-url" | "asset">}
 */
const ASSET_AND_CSS_URL_TYPES = new Set([ASSET_TYPE, CSS_URL_TYPE]);

/**
 * @type {ReadonlySet<"javascript" | "css-url" | "asset">}
 */
const ASSET_AND_JAVASCRIPT_AND_CSS_URL_TYPES = new Set([
	ASSET_TYPE,
	JAVASCRIPT_TYPE,
	CSS_URL_TYPE
]);

/**
 * @type {ReadonlySet<"javascript">}
 */
const JAVASCRIPT_TYPES = new Set([JAVASCRIPT_TYPE]);

/**
 * @type {ReadonlySet<"javascript" | "css-url">}
 */
const JAVASCRIPT_AND_CSS_URL_TYPES = new Set([JAVASCRIPT_TYPE, CSS_URL_TYPE]);

/**
 * @type {ReadonlySet<"javascript" | "css">}
 */
const JAVASCRIPT_AND_CSS_TYPES = new Set([JAVASCRIPT_TYPE, CSS_TYPE]);

/**
 * @type {ReadonlySet<"css">}
 */
const CSS_TYPES = new Set([CSS_TYPE]);

/**
 * @type {ReadonlySet<"css-url">}
 */
const CSS_URL_TYPES = new Set([CSS_URL_TYPE]);
/**
 * @type {ReadonlySet<"css-import">}
 */
const CSS_IMPORT_TYPES = new Set([CSS_IMPORT_TYPE]);

/**
 * @type {ReadonlySet<"webassembly">}
 */
const WEBASSEMBLY_TYPES = new Set([WEBASSEMBLY_TYPE]);

/**
 * @type {ReadonlySet<"runtime">}
 */
const RUNTIME_TYPES = new Set([RUNTIME_TYPE]);

/**
 * @type {ReadonlySet<"remote" | "share-init">}
 */
const REMOTE_AND_SHARE_INIT_TYPES = new Set([
	REMOTE_GENERATOR_TYPE,
	SHARED_INIT_TYPE
]);

/**
 * @type {ReadonlySet<"consume-shared">}
 */
const CONSUME_SHARED_TYPES = new Set([CONSUME_SHARED_GENERATOR_TYPE]);

/**
 * @type {ReadonlySet<"share-init">}
 */
const SHARED_INIT_TYPES = new Set([SHARED_INIT_TYPE]);

module.exports.ASSET_AND_CSS_URL_TYPES = ASSET_AND_CSS_URL_TYPES;
module.exports.ASSET_AND_JAVASCRIPT_AND_CSS_URL_TYPES =
	ASSET_AND_JAVASCRIPT_AND_CSS_URL_TYPES;
module.exports.ASSET_AND_JAVASCRIPT_TYPES = ASSET_AND_JAVASCRIPT_TYPES;
module.exports.ASSET_TYPE = ASSET_TYPE;
module.exports.ASSET_TYPES = ASSET_TYPES;
module.exports.CONSUME_SHARED_TYPES = CONSUME_SHARED_TYPES;
module.exports.CSS_IMPORT_TYPE = CSS_IMPORT_TYPE;
module.exports.CSS_IMPORT_TYPES = CSS_IMPORT_TYPES;
module.exports.CSS_TYPE = CSS_TYPE;
module.exports.CSS_TYPE = CSS_TYPE;
module.exports.CSS_TYPES = CSS_TYPES;
module.exports.CSS_URL_TYPE = CSS_URL_TYPE;
module.exports.CSS_URL_TYPES = CSS_URL_TYPES;
module.exports.JAVASCRIPT_AND_CSS_TYPES = JAVASCRIPT_AND_CSS_TYPES;
module.exports.JAVASCRIPT_AND_CSS_URL_TYPES = JAVASCRIPT_AND_CSS_URL_TYPES;
module.exports.JAVASCRIPT_TYPE = JAVASCRIPT_TYPE;
module.exports.JAVASCRIPT_TYPES = JAVASCRIPT_TYPES;
module.exports.NO_TYPES = NO_TYPES;
module.exports.REMOTE_AND_SHARE_INIT_TYPES = REMOTE_AND_SHARE_INIT_TYPES;
module.exports.RUNTIME_TYPE = RUNTIME_TYPE;
module.exports.RUNTIME_TYPES = RUNTIME_TYPES;
module.exports.SHARED_INIT_TYPE = SHARED_INIT_TYPE;
module.exports.SHARED_INIT_TYPES = SHARED_INIT_TYPES;
module.exports.UNKNOWN_TYPE = UNKNOWN_TYPE;
module.exports.WEBASSEMBLY_TYPE = WEBASSEMBLY_TYPE;
module.exports.WEBASSEMBLY_TYPES = WEBASSEMBLY_TYPES;
