<?php
// database/seeders/UsersSeeder.php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UsersSeeder extends Seeder
{
    public function run()
    {
        // Usuario Administrador
        $admin = User::create([
            'nombre' => 'Administrador',
            'apellidos' => 'Sistema',
            'dni' => '12345678',
            'password' => Hash::make('admin123'),
            'estado' => 'activo',
        ]);
        $admin->assignRole('administrador');

        // Usuario Proveedor
        $proveedor = User::create([
            'nombre' => 'Juan Carlos',
            'apellidos' => 'Pérez García',
            'dni' => '87654321',
            'password' => Hash::make('proveedor123'),
            'estado' => 'activo',
        ]);
        $proveedor->assignRole('proveedor');

        // Usuario Operador
        $operador = User::create([
            'nombre' => 'María Elena',
            'apellidos' => 'Rodríguez López',
            'dni' => '11223344',
            'password' => Hash::make('operador123'),
            'estado' => 'activo',
        ]);
        $operador->assignRole('operador');

        // Operador adicional
        $operador2 = User::create([
            'nombre' => 'Carlos Alberto',
            'apellidos' => 'Martínez Vega',
            'dni' => '44332211',
            'password' => Hash::make('operador123'),
            'estado' => 'activo',
        ]);
        $operador2->assignRole('operador');
    }
}
