<?php
// database/seeders/RolesAndPermissionsSeeder.php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolesAndPermissionsSeeder extends Seeder
{
    public function run()
    {
        // Resetear roles y permisos
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Crear permisos
        $permissions = [
            // Usuarios
            'users.index',
            'users.create',
            'users.edit',
            'users.delete',

            // Series
            'series.index',
            'series.create',
            'series.edit',
            'series.delete',
            'series.approve',
            'series.reject',

            // Proyectos
            'proyectos.index',
            'proyectos.create',
            'proyectos.edit',
            'proyectos.delete',
            'proyectos.update_status',
            'proyectos.upload_evidence',
            'proyectos.comment',

            // Dashboard
            'dashboard.admin',
            'dashboard.proveedor',
            'dashboard.operador',

            // Reportes
            'reportes.index',
            'reportes.export',

            // Auditoría
            'auditoria.index',
        ];

        foreach ($permissions as $permission) {
            Permission::create(['name' => $permission]);
        }

        // Crear roles y asignar permisos
        $adminRole = Role::create(['name' => 'administrador']);
        $proveedorRole = Role::create(['name' => 'proveedor']);
        $operadorRole = Role::create(['name' => 'operador']);

        // Asignar permisos a roles
        $adminRole->givePermissionTo(Permission::all());

        $proveedorRole->givePermissionTo([
            'series.index',
            'series.create',
            'series.edit',
            'proyectos.index',
            'proyectos.create',
            'proyectos.edit',
            'dashboard.proveedor',
        ]);

        $operadorRole->givePermissionTo([
            'proyectos.index',
            'proyectos.update_status',
            'proyectos.upload_evidence',
            'proyectos.comment',
            'dashboard.operador',
        ]);
    }
}
