<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ChangeEstadoColumnInEmpresasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('empresas', function (Blueprint $table) {
            $table->string('estado', 50)->default('pendiente')->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('empresas', function (Blueprint $table) {
            // Revertir a ENUM original (nota: fallará si hay valores fuera del rango)
            $table->enum('estado', ['pendiente', 'aprobada', 'rechazada', 'en_progreso', 'finalizada'])
                  ->default('pendiente')
                  ->change();
        });
    }
}
