<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSitioWebToEmpresasTable extends Migration
{
    public function up()
    {
        Schema::table('empresas', function (Blueprint $table) {
            if (!Schema::hasColumn('empresas', 'sitio_web')) {
                $table->string('sitio_web')->nullable()->after('nombre_comercial');
            }
        });
    }

    public function down()
    {
        Schema::table('empresas', function (Blueprint $table) {
            if (Schema::hasColumn('empresas', 'sitio_web')) {
                $table->dropColumn('sitio_web');
            }
        });
    }
}
