<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmpresaRucsTable extends Migration
{
    public function up()
    {
        Schema::create('empresa_rucs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('empresa_id')->index();
            $table->string('ruc', 11);
            $table->string('razon_social');
            $table->string('serie', 3)->nullable();
            $table->string('usuario_sol')->nullable();
            $table->string('clave_sol')->nullable();
            $table->string('usuario_secundario_dni')->nullable();
            $table->string('usuario_secundario_user')->nullable();
            $table->string('usuario_secundario_clave')->nullable();
            $table->string('clave_certificado')->nullable();
            $table->timestamps();

            $table->unique(['empresa_id', 'ruc']);
            $table->foreign('empresa_id')->references('id')->on('empresas')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('empresa_rucs');
    }
}
