<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMissingColumnsToEmpresasTable extends Migration
{
    public function up()
    {
        Schema::table('empresas', function (Blueprint $table) {
            if (!Schema::hasColumn('empresas', 'descripcion')) {
                $table->text('descripcion')->nullable();
            }
            if (!Schema::hasColumn('empresas', 'fecha_solicitud')) {
                $table->date('fecha_solicitud')->nullable();
            }
            if (!Schema::hasColumn('empresas', 'estado')) {
                $table->string('estado')->default('pendiente')->index();
            }
            if (!Schema::hasColumn('empresas', 'proveedor_id')) {
                $table->unsignedBigInteger('proveedor_id')->nullable()->index();
            }
            if (!Schema::hasColumn('empresas', 'aprobado_por')) {
                $table->unsignedBigInteger('aprobado_por')->nullable()->index();
            }
            if (!Schema::hasColumn('empresas', 'fecha_aprobacion')) {
                $table->dateTime('fecha_aprobacion')->nullable();
            }
            if (!Schema::hasColumn('empresas', 'comentarios_aprobacion')) {
                $table->text('comentarios_aprobacion')->nullable();
            }
        });

    }

    public function down()
    {
        Schema::table('empresas', function (Blueprint $table) {
            if (Schema::hasColumn('empresas', 'descripcion')) {
                $table->dropColumn('descripcion');
            }
            if (Schema::hasColumn('empresas', 'fecha_solicitud')) {
                $table->dropColumn('fecha_solicitud');
            }
            if (Schema::hasColumn('empresas', 'estado')) {
                $table->dropColumn('estado');
            }
            if (Schema::hasColumn('empresas', 'proveedor_id')) {
                $table->dropColumn('proveedor_id');
            }
            if (Schema::hasColumn('empresas', 'aprobado_por')) {
                $table->dropColumn('aprobado_por');
            }
            if (Schema::hasColumn('empresas', 'fecha_aprobacion')) {
                $table->dropColumn('fecha_aprobacion');
            }
            if (Schema::hasColumn('empresas', 'comentarios_aprobacion')) {
                $table->dropColumn('comentarios_aprobacion');
            }
        });
    }
}
