<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddExtraFieldsToEmpresasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('empresas', function (Blueprint $table) {
            $table->string('serie', 3)->nullable()->after('razon_social')->comment('Código de serie ej: 001');
            $table->string('usuario_secundario_dni')->nullable()->after('clave_sol');
            $table->string('usuario_secundario_user')->nullable()->after('usuario_secundario_dni');
            $table->string('usuario_secundario_clave')->nullable()->after('usuario_secundario_user');
            $table->string('clave_certificado')->nullable()->after('usuario_secundario_clave');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('empresas', function (Blueprint $table) {
            $table->dropColumn([
                'serie',
                'usuario_secundario_dni',
                'usuario_secundario_user',
                'usuario_secundario_clave',
                'clave_certificado'
            ]);
        });
    }
}
