<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class CreateEmpresaUserTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('empresa_user', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('empresa_id');
            $table->unsignedBigInteger('user_id'); // Proveedor ID
            $table->timestamps();

            $table->foreign('empresa_id')->references('id')->on('empresas')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            
            // Evitar duplicados
            $table->unique(['empresa_id', 'user_id']);
        });

        // Migrar datos existentes: Mover el proveedor_id de la tabla empresas a la nueva tabla pivote
        $empresas = DB::table('empresas')->whereNotNull('proveedor_id')->get();
        
        foreach ($empresas as $empresa) {
            DB::table('empresa_user')->insert([
                'empresa_id' => $empresa->id,
                'user_id' => $empresa->proveedor_id,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('empresa_user');
    }
}
