<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class AddCanceladoToTareasEstado extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Using raw SQL because changing enum columns with Schema builder is problematic
        // and ensures we don't need extra dependencies like doctrine/dbal.
        DB::statement("ALTER TABLE tareas MODIFY COLUMN estado ENUM('pendiente', 'en_progreso', 'finalizado', 'cancelado') DEFAULT 'pendiente'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Update 'cancelado' to 'finalizado' before reverting to avoid data loss/error
        DB::statement("UPDATE tareas SET estado = 'finalizado' WHERE estado = 'cancelado'");
        
        DB::statement("ALTER TABLE tareas MODIFY COLUMN estado ENUM('pendiente', 'en_progreso', 'finalizado') DEFAULT 'pendiente'");
    }
}
