<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class FixComentariosEvidenciasColumns extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $tables = ['comentarios', 'evidencias'];

        foreach ($tables as $tableName) {
            if (Schema::hasTable($tableName)) {
                
                // 1. Agregar columna tarea_id si no existe
                Schema::table($tableName, function (Blueprint $table) use ($tableName) {
                    if (!Schema::hasColumn($tableName, 'tarea_id')) {
                        $table->unsignedBigInteger('tarea_id')->nullable()->after('id');
                    }
                });

                // 2. Copiar datos de proyecto_id a tarea_id
                if (Schema::hasColumn($tableName, 'proyecto_id')) {
                    DB::statement("UPDATE {$tableName} SET tarea_id = proyecto_id WHERE tarea_id IS NULL");

                    // 3. Eliminar FK y columna proyecto_id
                    Schema::table($tableName, function (Blueprint $table) use ($tableName) {
                        // Intentar borrar FK antigua si existe
                        try {
                            $table->dropForeign("{$tableName}_proyecto_id_foreign");
                        } catch (\Exception $e) {
                            try {
                                $table->dropForeign(['proyecto_id']);
                            } catch (\Exception $e2) {}
                        }
                        
                        $table->dropColumn('proyecto_id');
                    });
                }

                // 4. Agregar nueva FK
                Schema::table($tableName, function (Blueprint $table) {
                    try {
                        $table->foreign('tarea_id')->references('id')->on('tareas')->onDelete('cascade');
                    } catch (\Exception $e) {}
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $tables = ['comentarios', 'evidencias'];

        foreach ($tables as $tableName) {
            if (Schema::hasTable($tableName)) {
                Schema::table($tableName, function (Blueprint $table) {
                    if (!Schema::hasColumn($tableName, 'proyecto_id')) {
                        $table->unsignedBigInteger('proyecto_id')->nullable()->after('id');
                    }
                });

                if (Schema::hasColumn($tableName, 'tarea_id')) {
                    DB::statement("UPDATE {$tableName} SET proyecto_id = tarea_id WHERE proyecto_id IS NULL");
                    
                    Schema::table($tableName, function (Blueprint $table) {
                        try {
                            $table->dropForeign(['tarea_id']);
                        } catch (\Exception $e) {}
                        $table->dropColumn('tarea_id');
                    });
                }
            }
        }
    }
}
