<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class RefactorSeriesToEmpresasAndProyectosToTareas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // 1. Renombrar tablas (si no han sido renombradas ya)
        if (Schema::hasTable('serie_proyectos') && !Schema::hasTable('empresas')) {
            Schema::rename('serie_proyectos', 'empresas');
        }
        if (Schema::hasTable('proyectos') && !Schema::hasTable('tareas')) {
            Schema::rename('proyectos', 'tareas');
        }

        // 2. Modificar tabla 'empresas'
        Schema::table('empresas', function (Blueprint $table) {
            if (!Schema::hasColumn('empresas', 'ruc')) {
                $table->string('ruc', 11)->unique()->nullable()->after('id');
                $table->string('razon_social')->nullable()->after('ruc');
                $table->string('nombre_comercial')->nullable()->after('razon_social');
                $table->string('usuario_sol')->nullable()->after('nombre_comercial');
                $table->string('clave_sol')->nullable()->after('usuario_sol');
            }
        });

        // 3. Modificar tabla 'tareas'
        Schema::table('tareas', function (Blueprint $table) {
            if (!Schema::hasColumn('tareas', 'empresa_id')) {
                $table->unsignedBigInteger('empresa_id')->nullable()->after('id');
            }
        });

        // Copiar datos de serie_id a empresa_id
        DB::statement('UPDATE tareas SET empresa_id = serie_id WHERE empresa_id IS NULL');

        Schema::table('tareas', function (Blueprint $table) {
             // Eliminar la FK anterior usando el nombre correcto
             if (Schema::hasColumn('tareas', 'serie_id')) {
                 try {
                    $table->dropForeign('proyectos_serie_id_foreign');
                 } catch (\Exception $e) {
                    try {
                        $table->dropForeign(['serie_id']);
                    } catch (\Exception $e2) {
                    }
                 }
                 
                 $table->dropColumn('serie_id');
             }
        });
        
        // Agregar la FK en un bloque separado
        Schema::table('tareas', function (Blueprint $table) {
             try {
                $table->foreign('empresa_id')->references('id')->on('empresas')->onDelete('cascade');
             } catch (\Exception $e) {}
        });

        // 4. Modificar tablas relacionadas (comentarios, evidencias)
        $tables = ['comentarios', 'evidencias'];
        foreach ($tables as $tableName) {
            if (Schema::hasTable($tableName)) {
                Schema::table($tableName, function (Blueprint $table) use ($tableName) {
                    if (!Schema::hasColumn($tableName, 'tarea_id')) {
                        $table->unsignedBigInteger('tarea_id')->nullable()->after('id');
                    }
                });

                // Copiar datos
                if (Schema::hasColumn($tableName, 'proyecto_id')) {
                    DB::statement("UPDATE {$tableName} SET tarea_id = proyecto_id WHERE tarea_id IS NULL");
                
                    Schema::table($tableName, function (Blueprint $table) use ($tableName) {
                        // Intentar borrar FK antigua si existe
                        try {
                            $table->dropForeign("{$tableName}_proyecto_id_foreign");
                        } catch (\Exception $e) {
                             try {
                                $table->dropForeign(['proyecto_id']);
                            } catch (\Exception $e2) {}
                        }
                        $table->dropColumn('proyecto_id');
                    });
                }
                
                Schema::table($tableName, function (Blueprint $table) {
                    try {
                        $table->foreign('tarea_id')->references('id')->on('tareas')->onDelete('cascade');
                    } catch (\Exception $e) {}
                });
            }
        }

        // Limpieza final en empresas
        Schema::table('empresas', function (Blueprint $table) {
            if (Schema::hasColumn('empresas', 'titulo')) {
                $table->dropColumn('titulo');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Revertir cambios en orden inverso

        // 1. Revertir tabla 'tareas'
        Schema::table('tareas', function (Blueprint $table) {
            $table->unsignedBigInteger('serie_id')->nullable()->after('id');
        });

        DB::statement('UPDATE tareas SET serie_id = empresa_id');

        Schema::table('tareas', function (Blueprint $table) {
            $table->dropForeign(['empresa_id']);
            $table->dropColumn('empresa_id');
            $table->foreign('serie_id')->references('id')->on('empresas'); // Apunta a 'empresas' temporalmente
        });

        // 2. Revertir tabla 'empresas'
        Schema::table('empresas', function (Blueprint $table) {
            $table->string('titulo')->nullable();
            $table->dropColumn(['ruc', 'razon_social', 'nombre_comercial', 'usuario_sol', 'clave_sol']);
        });

        // 3. Renombrar tablas a original
        Schema::rename('tareas', 'proyectos');
        Schema::rename('empresas', 'serie_proyectos');
    }
}
