<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddEmailAndUsernameToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('username')->nullable()->after('id');
            $table->string('email')->nullable()->after('apellidos');
            $table->timestamp('email_verified_at')->nullable()->after('email');
        });

        // Llenar datos existentes para evitar errores de unicidad
        $users = \App\Models\User::all();
        foreach ($users as $user) {
            $user->username = $user->dni; // Usar DNI como username temporal
            $user->email = $user->dni . '@example.com'; // Email temporal
            $user->save();
        }

        Schema::table('users', function (Blueprint $table) {
            $table->string('username')->nullable(false)->unique()->change();
            $table->string('email')->nullable(false)->unique()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['username', 'email', 'email_verified_at']);
        });
    }
}
