<?php
// database/migrations/2024_01_01_000002_create_proyectos_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProyectosTable extends Migration
{
    public function up()
    {
        Schema::create('proyectos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('serie_id')->constrained('serie_proyectos');
            $table->string('titulo');
            $table->text('descripcion');
            $table->date('fecha_inicio_estimada');
            $table->date('fecha_fin_estimada');
            $table->date('fecha_inicio_real')->nullable();
            $table->date('fecha_fin_real')->nullable();
            $table->enum('prioridad', ['baja', 'media', 'alta', 'urgente'])->default('media');
            $table->enum('estado', ['pendiente', 'en_progreso', 'finalizado'])->default('pendiente');
            $table->foreignId('operador_id')->constrained('users');
            $table->integer('orden')->default(1);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('proyectos');
    }
}
