<?php
// database/migrations/2024_01_01_000001_create_serie_proyectos_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSerieProyectosTable extends Migration
{
    public function up()
    {
        Schema::create('serie_proyectos', function (Blueprint $table) {
            $table->id();
            $table->string('titulo');
            $table->text('descripcion')->nullable();
            $table->date('fecha_solicitud');
            $table->enum('estado', ['pendiente', 'aprobada', 'rechazada', 'en_progreso', 'finalizada'])
                ->default('pendiente');
            $table->foreignId('proveedor_id')->constrained('users');
            $table->foreignId('aprobado_por')->nullable()->constrained('users');
            $table->timestamp('fecha_aprobacion')->nullable();
            $table->text('comentarios_aprobacion')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('serie_proyectos');
    }
}
