<?php
// app/Providers/AuthServiceProvider.php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use App\Models\Empresa;
use App\Models\Tarea;
use App\Policies\EmpresaPolicy;
use App\Policies\TareaPolicy;

class AuthServiceProvider extends ServiceProvider
{
    protected $policies = [
        Empresa::class => EmpresaPolicy::class,
        Tarea::class => TareaPolicy::class,
        \App\Models\Evidencia::class => \App\Policies\EvidenciaPolicy::class,
        \App\Models\Material::class => \App\Policies\MaterialPolicy::class,
    ];

    public function register()
    {
        //
    }

    public function boot()
    {
        $this->registerPolicies();
    }
}

// namespace App\Providers;

// use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
// use Illuminate\Support\Facades\Gate;

// class AuthServiceProvider extends ServiceProvider
// {
//     /**
//      * The policy mappings for the application.
//      *
//      * @var array
//      */
//     protected $policies = [
//         // 'App\Model' => 'App\Policies\ModelPolicy',
//     ];

//     /**
//      * Register any authentication / authorization services.
//      *
//      * @return void
//      */
//     public function boot()
//     {
//         $this->registerPolicies();

//         //
//     }
// }
