<?php
// app/Policies/UserPolicy.php

namespace App\Policies;

use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class UserPolicy
{
    use HandlesAuthorization;

    public function viewAny(User $user)
    {
        // Solo administradores pueden ver lista de usuarios
        return $user->hasRole('administrador');
    }

    public function view(User $user, User $model)
    {
        // Administrador puede ver cualquier usuario
        if ($user->hasRole('administrador')) {
            return true;
        }

        // Un usuario puede ver su propio perfil
        return $user->id == $model->id;
    }

    public function create(User $user)
    {
        // Solo administradores pueden crear usuarios
        return $user->hasRole('administrador');
    }

    public function update(User $user, User $model)
    {
        // Administrador puede actualizar cualquier usuario
        if ($user->hasRole('administrador')) {
            return true;
        }

        // Un usuario puede actualizar su propio perfil
        return $user->id == $model->id;
    }

    public function delete(User $user, User $model)
    {
        // Solo administradores pueden eliminar usuarios
        if (!$user->hasRole('administrador')) {
            return false;
        }

        // No se puede eliminar a sí mismo
        return $user->id != $model->id;
    }

    public function changeRole(User $user, User $model)
    {
        // Solo administradores pueden cambiar roles
        if (!$user->hasRole('administrador')) {
            return false;
        }

        // No puede cambiar su propio rol
        return $user->id != $model->id;
    }
}
