<?php

namespace App\Policies;

use App\Models\Material;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class MaterialPolicy
{
    use HandlesAuthorization;

    public function viewAny(User $user)
    {
        return $user->hasAnyRole(['administrador', 'proveedor', 'operador']);
    }

    public function view(User $user, Material $material)
    {
        if ($user->hasRole('administrador')) {
            return true;
        }

        $tarea = $material->tarea;

        if ($user->hasRole('proveedor')) {
            return $tarea->empresa->proveedor_id == $user->id;
        }

        if ($user->hasRole('operador')) {
            return $tarea->operador_id == $user->id;
        }

        return false;
    }

    public function create(User $user)
    {
        // Administradores y proveedores pueden subir material
        return $user->hasAnyRole(['administrador', 'proveedor']);
    }

    public function delete(User $user, Material $material)
    {
        if ($user->hasRole('administrador')) {
            return true;
        }

        // El proveedor dueño de la tarea o quien lo subió puede eliminar
        if ($user->hasRole('proveedor')) {
            return $material->tarea->empresa->proveedor_id == $user->id || $material->user_id == $user->id;
        }

        return false;
    }

    public function download(User $user, Material $material)
    {
        return $this->view($user, $material);
    }
}
