<?php
// app/Models/User.php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasFactory, Notifiable, HasRoles;

    protected $fillable = [
        'nombre',
        'apellidos',
        'dni',
        'email',
        'username',
        'password',
        'estado',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'dni_verified_at' => 'datetime',
    ];

    // Relaciones
    public function empresasAsignadas()
    {
        return $this->belongsToMany(Empresa::class, 'empresa_user', 'user_id', 'empresa_id');
    }

    public function empresasCreadas()
    {
        return $this->hasMany(Empresa::class, 'proveedor_id');
    }

    public function empresasAprobadas()
    {
        return $this->hasMany(Empresa::class, 'aprobado_por');
    }

    public function tareasAsignadas()
    {
        return $this->hasMany(Tarea::class, 'operador_id');
    }

    public function comentarios()
    {
        return $this->hasMany(Comentario::class);
    }

    public function evidencias()
    {
        return $this->hasMany(Evidencia::class);
    }

    public function notificaciones()
    {
        return $this->hasMany(Notificacion::class);
    }

    // Accessors
    public function getNombreCompletoAttribute()
    {
        return $this->nombre . ' ' . $this->apellidos;
    }

    public function getNombreCortoAttribute()
    {
        $nombre = explode(' ', trim($this->nombre))[0];
        $apellido = explode(' ', trim($this->apellidos))[0];
        return $nombre . ' ' . $apellido;
    }

    // Overrides para autenticación
    public function getAuthIdentifierName()
    {
        return 'username';
    }

    public function findForPassport($username)
    {
        return $this->where('username', $username)
                    ->orWhere('email', $username)
                    ->orWhere('dni', $username) // Mantenemos compatibilidad si se desea
                    ->first();
    }
}
