<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmpresaRuc extends Model
{
    use HasFactory;

    protected $table = 'empresa_rucs';

    protected $fillable = [
        'empresa_id',
        'ruc',
        'razon_social',
        'serie',
        'usuario_sol',
        'clave_sol',
        'usuario_secundario_dni',
        'usuario_secundario_user',
        'usuario_secundario_clave',
        'clave_certificado',
    ];

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }
}
