<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

use App\Models\ApiKey;
use Carbon\Carbon;

class CheckApiKey
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $requestApiKey = $request->header('X-API-KEY') ?? $request->query('api_key');

        if (!$requestApiKey) {
            return response()->json([
                'success' => false,
                'message' => 'Unauthorized: API Key missing'
            ], 401);
        }

        // Check if key exists in DB, is active, and not expired
        $apiKey = ApiKey::where('key', $requestApiKey)
            ->where('is_active', true)
            ->where(function ($query) {
                $query->whereNull('expires_at')
                    ->orWhere('expires_at', '>', Carbon::now());
            })
            ->first();

        if (!$apiKey) {
            return response()->json([
                'success' => false,
                'message' => 'Unauthorized: Invalid or expired API Key'
            ], 401);
        }

        return $next($request);
    }
}
