<?php

namespace App\Http\Controllers;

use App\Models\Empresa;
use Illuminate\Http\Request;

class PublicoController extends Controller
{
    public function index()
    {
        return view('publico.consulta');
    }

    public function buscar(Request $request)
    {
        $request->validate([
            'ruc' => 'required|numeric|digits:11'
        ]);

        $empresa = Empresa::where('ruc', $request->ruc)
            ->with(['tareas' => function($query) {
                $query->orderBy('fecha_inicio_estimada', 'asc');
            }]) 
            ->first();

        if (!$empresa) {
            return back()->with('error', 'No se encontró ninguna empresa con el RUC proporcionado.');
        }

        return view('publico.resultado', compact('empresa'));
    }
}
