<?php
// app/Http/Controllers/Operador/DashboardController.php

namespace App\Http\Controllers\Operador;

use App\Http\Controllers\Controller;
use App\Models\Tarea;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'role:operador']);
    }

    public function index()
    {
        $user = auth()->user();

        $stats = [
            'tareas_asignadas' => Tarea::where('operador_id', $user->id)->count(),
            'tareas_pendientes' => Tarea::where('operador_id', $user->id)
                ->where('estado', 'pendiente')
                ->count(),
            'tareas_en_progreso' => Tarea::where('operador_id', $user->id)
                ->where('estado', 'en_progreso')
                ->count(),
            'tareas_finalizadas' => Tarea::where('operador_id', $user->id)
                ->where('estado', 'finalizado')
                ->count(),
        ];

        $tareasPendientes = Tarea::where('operador_id', $user->id)
            ->where('estado', 'pendiente')
            ->with('empresa')
            ->orderBy('prioridad')
            ->orderBy('fecha_inicio_estimada')
            ->take(5)
            ->get();

        $tareasEnProgreso = Tarea::where('operador_id', $user->id)
            ->where('estado', 'en_progreso')
            ->with('empresa')
            ->orderBy('fecha_fin_estimada')
            ->take(5)
            ->get();

        $tareasUrgentes = Tarea::where('operador_id', $user->id)
            ->where('prioridad', 'urgente')
            ->where('estado', '!=', 'finalizado')
            ->with('empresa')
            ->orderBy('fecha_fin_estimada')
            ->get();

        return view('operador.dashboard', compact(
            'stats',
            'tareasPendientes',
            'tareasEnProgreso',
            'tareasUrgentes'
        ));
    }
}
