<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $user = auth()->user();

        if ($user->hasRole('administrador')) {
            return redirect()->route('admin.dashboard');
        } elseif ($user->hasRole('proveedor')) {
            return redirect()->route('proveedor.dashboard');
        } elseif ($user->hasRole('operador')) {
            return redirect()->route('operador.dashboard');
        }

        return view('home');
    }
}
