<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Empresa;
use Illuminate\Http\Request;

class EmpresaApiController extends Controller
{
    /**
     * Obtener información de empresa (RUC, Usuario SOL, Clave SOL) por RUC.
     *
     * @param string $ruc
     * @return \Illuminate\Http\JsonResponse
     */
    public function getByRuc($ruc)
    {
        $empresa = Empresa::where('ruc', $ruc)->first();

        if (!$empresa) {
            return response()->json([
                'success' => false,
                'message' => 'Empresa no encontrada'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => [
                'ruc' => $empresa->ruc,
                'razon_social' => $empresa->razon_social,
                'nombre_comercial' => $empresa->nombre_comercial,
                'serie' => $empresa->serie,
                'usuario_sol' => $empresa->usuario_sol,
                'clave_sol' => $empresa->clave_sol,
                'usuario_secundario_dni' => $empresa->usuario_secundario_dni,
                'usuario_secundario_user' => $empresa->usuario_secundario_user,
                'usuario_secundario_clave' => $empresa->usuario_secundario_clave,
                'clave_certificado' => $empresa->clave_certificado,
            ]
        ]);
    }
}
