<?php

namespace App\Http\Controllers;

use App\Models\AnydeskTerminal;
use App\Models\Empresa;
use Illuminate\Http\Request;

class AnydeskTerminalController extends Controller
{
    public function index(Request $request)
    {
        $query = AnydeskTerminal::with('empresa');

        if ($request->filled('search')) {
            $search = $request->search;
            $query->where(function($q) use ($search) {
                $q->where('nombre', 'like', "%{$search}%")
                  ->orWhere('id_trabajo', 'like', "%{$search}%")
                  ->orWhereHas('empresa', function($q2) use ($search) {
                      $q2->where('razon_social', 'like', "%{$search}%")
                         ->orWhere('nombre_comercial', 'like', "%{$search}%");
                  });
            });
        }

        $terminals = $query->latest()->paginate(10);
        $empresas = Empresa::orderBy('nombre_comercial')->get();

        return view('anydesk_terminals.index', compact('terminals', 'empresas'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'nombre' => 'required|string|max:255',
            'id_trabajo' => 'required|string|max:255',
            'clave' => 'nullable|string|max:255',
            'empresa_id' => 'nullable|exists:empresas,id',
        ]);

        AnydeskTerminal::create($request->all());

        return redirect()->route('admin.anydesk.index')
            ->with('success', 'Terminal de Anydesk registrado correctamente.');
    }

    public function update(Request $request, AnydeskTerminal $anydesk)
    {
        $request->validate([
            'nombre' => 'required|string|max:255',
            'id_trabajo' => 'required|string|max:255',
            'clave' => 'nullable|string|max:255',
            'empresa_id' => 'nullable|exists:empresas,id',
        ]);

        $anydesk->update($request->all());

        return redirect()->route('admin.anydesk.index')
            ->with('success', 'Terminal de Anydesk actualizado correctamente.');
    }

    public function destroy(AnydeskTerminal $anydesk)
    {
        $anydesk->delete();

        return redirect()->route('admin.anydesk.index')
            ->with('success', 'Terminal de Anydesk eliminado correctamente.');
    }
}
