<?php
// app/Http/Controllers/Admin/DashboardController.php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Empresa;
use App\Models\Tarea;
use App\Models\Auditoria;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'role:administrador']);
    }

    public function index()
    {
        $stats = [
            'usuarios_total' => User::count(),
            'usuarios_activos' => User::where('estado', 'activo')->count(),
            'empresas_pendientes' => Empresa::pendientes()->count(),
            'empresas_aprobadas' => Empresa::aprobadas()->count(),
            'tareas_total' => Tarea::count(),
            'tareas_en_progreso' => Tarea::enProgreso()->count(),
            'tareas_finalizadas' => Tarea::where('estado', 'finalizado')->count(),
        ];

        $empresasPendientes = Empresa::pendientes()
            ->with('proveedor')
            ->latest()
            ->take(5)
            ->get();

        $tareasUrgentes = Tarea::where('prioridad', 'urgente')
            ->where('estado', '!=', 'finalizado')
            ->with(['empresa', 'operador'])
            ->latest()
            ->take(5)
            ->get();

        $actividadReciente = Auditoria::with('user')
            ->latest()
            ->take(10)
            ->get();

        return view('admin.dashboard', compact('stats', 'empresasPendientes', 'tareasUrgentes', 'actividadReciente'));
    }
}
