<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ApiKey;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class ApiKeyController extends Controller
{
    public function index()
    {
        $currentKey = ApiKey::where('is_active', true)
            ->where(function ($query) {
                $query->whereNull('expires_at')
                    ->orWhere('expires_at', '>', Carbon::now());
            })
            ->latest()
            ->first();

        return view('admin.api_keys.index', compact('currentKey'));
    }

    public function regenerate(Request $request)
    {
        // Deactivate all previous keys
        ApiKey::where('is_active', true)->update(['is_active' => false]);

        // Create new key
        $months = $request->input('duration', 1);
        
        $apiKey = ApiKey::create([
            'key' => (string) Str::uuid(),
            'name' => 'System Key',
            'expires_at' => Carbon::now()->addMonths($months),
            'is_active' => true,
        ]);

        return redirect()->back()->with('success', 'Nueva API Key generada con éxito. Expira en ' . $months . ' mes(es).');
    }
}
