<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Tarea;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;

class AgenteTareas extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'agente:ejecutar';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Agente automatizado para gestión de tareas (recordatorios, vencimientos, reportes)';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('Iniciando ejecución del Agente de Tareas...');
        Log::info('Agente de Tareas: Inicio de ejecución');

        // 1. Identificar Tareas Vencidas
        $hoy = Carbon::now()->startOfDay();
        
        $tareasVencidas = Tarea::where('fecha_fin_estimada', '<', $hoy)
            ->where('estado', '!=', 'finalizado')
            ->get();

        $count = $tareasVencidas->count();

        if ($count > 0) {
            $this->warn("Se encontraron {$count} tareas vencidas.");
            
            foreach ($tareasVencidas as $tarea) {
                $this->line("- Tarea ID: {$tarea->id} | Título: {$tarea->titulo} | Vencimiento: {$tarea->fecha_fin_estimada->format('Y-m-d')}");
                
                // Aquí podrías agregar lógica para:
                // - Enviar correo al operador
                // - Marcar como 'vencida' si tienes ese estado
                // - Crear una notificación en el sistema
            }
        } else {
            $this->info('No hay tareas vencidas pendientes.');
        }

        // 2. Identificar Tareas Próximas a Vencer (Mañana)
        $manana = Carbon::tomorrow();
        $tareasProximas = Tarea::where('fecha_fin_estimada', '=', $manana)
            ->where('estado', '!=', 'finalizado')
            ->count();

        if ($tareasProximas > 0) {
            $this->info("Hay {$tareasProximas} tareas que vencen mañana.");
        }

        $this->info('Agente finalizó su ejecución correctamente.');
        Log::info('Agente de Tareas: Fin de ejecución');

        return 0;
    }
}
