const { sequelize, User, Wallet } = require('./models');

const seed = async () => {
  try {
    await sequelize.sync();
    
    const existingAdmin = await User.findOne({ where: { email: 'admin@ganared.com' } });
    if (existingAdmin) {
      console.log('Admin user already exists');
      return;
    }

    // El hook beforeCreate en el modelo User se encargará de hashear la contraseña
    const admin = await User.create({
      username: 'admin',
      email: 'admin@ganared.com',
      password: 'admin123', 
      role: 'admin',
      referralCode: 'ADMIN1'
    });

    // Crear wallet para admin
    await Wallet.create({
      userId: admin.id,
      balance: 10000.00
    });

    console.log('Usuario Admin creado exitosamente:');
    console.log('Email: admin@ganared.com');
    console.log('Password: admin123');
  } catch (error) {
    console.error('Error seeding database:', error);
  } finally {
    await sequelize.close();
  }
};

seed();
