const express = require('express');
const router = express.Router();
const { 
  getWalletSummary, 
  getTransactions,
  requestDeposit,
  requestWithdrawal,
  getAllTransactions,
  updateTransactionStatus
} = require('../controllers/walletController');
const { protect, admin } = require('../middleware/authMiddleware');

router.get('/summary', protect, getWalletSummary);
router.get('/transactions', protect, getTransactions);
router.post('/deposit', protect, requestDeposit);
router.post('/withdraw', protect, requestWithdrawal);

// Admin Routes
router.get('/admin/transactions', protect, admin, getAllTransactions);
router.put('/admin/transactions/:id', protect, admin, updateTransactionStatus);

module.exports = router;
