const Sequelize = require('sequelize');
const sequelize = require('../config/db');

const User = require('./User');
const Wallet = require('./Wallet');
const Task = require('./Task');
const Transaction = require('./Transaction');
const UserTask = require('./UserTask');
const Setting = require('./Setting');
const ActivityLog = require('./ActivityLog');

// Relaciones

// User tiene una Wallet
User.hasOne(Wallet, { foreignKey: 'userId', as: 'wallet' });
Wallet.belongsTo(User, { foreignKey: 'userId' });

// User tiene Logs de Actividad
User.hasMany(ActivityLog, { foreignKey: 'userId' });
ActivityLog.belongsTo(User, { foreignKey: 'userId' });

// User tiene un Padre (Referido)
User.belongsTo(User, { as: 'parent', foreignKey: 'parentId' });
User.hasMany(User, { as: 'children', foreignKey: 'parentId' });

// Wallet tiene muchas Transacciones
Wallet.hasMany(Transaction, { foreignKey: 'walletId' });
Transaction.belongsTo(Wallet, { foreignKey: 'walletId' });

// Relaciones Many-to-Many entre User y Task a través de UserTask
User.belongsToMany(Task, { through: UserTask, foreignKey: 'userId', as: 'tasks' });
Task.belongsToMany(User, { through: UserTask, foreignKey: 'taskId', as: 'users' });
UserTask.belongsTo(User, { foreignKey: 'userId' });
UserTask.belongsTo(Task, { foreignKey: 'taskId' });

// Sincronización de modelos con la base de datos
const syncDB = async () => {
  try {
    await sequelize.sync({ alter: false }); // Se cambia a false para evitar errores de llaves duplicadas
    console.log('Base de datos sincronizada.');
  } catch (error) {
    console.error('Error al sincronizar la base de datos:', error);
  }
};

module.exports = {
  sequelize,
  syncDB,
  User,
  Wallet,
  Task,
  Transaction,
  UserTask,
  Setting,
  ActivityLog
};
