//for save method string

var save_method;

var table;

var tables;

$(document).ready(function() {

  jQuery('#ubicacion').tagsInput({width:'auto'});

  $("#codigoexterno").mayusculassintildes();

  $("#nombre").mayusculassintildes();

  $("#unidad").mayusculassintildes();

  $("#minimo").numeric();

  $('.money').number(true, 2);

  $("#categoria").change(function() {

    var dato = {

      "categoria": $('#categoria').val(),

      "marca": $('#marca').val(),

      "familia": $('#familia').val()

    };

    $.ajax({

      data: dato,

      url: 'producto/codigo',

      type: 'post',

      success: function(data) {

        $("#codigo").val(data.codigo);

        $("#numero").val(data.numero);

      }

    });

    if ($('#categoria').val() == '0') {

      $('#marcas').show();

      $('#familias').show();

      $('#codigoexternos').show();

      $('#minimos').show();

      $('#preciocompras').show();

    } else {

      $('#marcas').hide();

      $('#familias').hide();

      $('#codigoexternos').hide();

      $('#minimos').hide();

      $('#preciocompras').hide();

    }

  });

  $("#marca").change(function() {

    var dato = {

      "categoria": $('#categoria').val(),

      "marca": $('#marca').val(),

      "familia": $('#familia').val()

    };

    $.ajax({

      data: dato,

      url: 'producto/codigo',

      type: 'post',

      success: function(data) {

        $("#codigo").val(data.codigo);

        $("#numero").val(data.numero);

      }

    });

  });

  $("#familia").change(function() {

    var dato = {

      "categoria": $('#categoria').val(),

      "marca": $('#marca').val(),

      "familia": $('#familia').val()

    };

    $.ajax({

      data: dato,

      url: 'producto/codigo',

      type: 'post',

      success: function(data) {

        $("#codigo").val(data.codigo);

        $("#numero").val(data.numero);

      }

    });

  });

  //datatables

  table = $('#tabla').DataTable({

    language: {

      "decimal": "",

      "emptyTable": "No hay información",

      "info": "Mostrando _START_ a _END_ de _TOTAL_ Entradas",

      "infoEmpty": "Mostrando 0 to 0 of 0 Entradas",

      "infoFiltered": "(Filtrado de _MAX_ total entradas)",

      "infoPostFix": "",

      "thousands": ",",

      "lengthMenu": "Mostrar _MENU_ Entradas",

      "loadingRecords": "Cargando...",

      "processing": "Procesando...",

      "search": "Buscar:",

      "zeroRecords": "Sin resultados encontrados",

      "paginate": {

          "first": "Primero",

          "last": "Ultimo",

          "next": "Siguiente",

          "previous": "Anterior"

      }

    },

    //Feature control the processing indicator.

    "processing": true,

    //Feature control DataTables' server-side processing mode.

    "serverSide": true,

    //Initial no order.

    "order": [],

    // Load data for the table's content from an Ajax source

    "ajax": {

      "url": "producto/ajax_list",

      "type": "POST"

    },

    //Set column definition initialisation properties.

    "columnDefs": [{

      //last column

      "targets": [-1],

      //set not orderable

      "orderable": true,

    }],

  });

  //set input/textarea/select event when change value, remove class error and remove text help block

  $("input").change(function() {

    $(this).parent().parent().removeClass('has-error');

    $(this).next().empty();

  });

  $("textarea").change(function() {

    $(this).parent().parent().removeClass('has-error');

    $(this).next().empty();

  });

  $("select").change(function() {

    $(this).parent().parent().removeClass('has-error');

    $(this).next().empty();

  });

  jQuery(".opcion").select2({

    width: '100%'

  });

});



function add() {

  save_method = 'add';

  $('#marcas').hide();

  $('#familias').hide();

  $('#codigoexternos').hide();

  $('#minimos').hide();

  $('#preciocompras').hide();

  $('#form')[0].reset(); // reset form on modals

  $('.form-group').removeClass('has-error'); // clear error class

  $('.help-block').empty(); // clear error string

  $('#modal_form').modal('show'); // show bootstrap modal

  $('.modal-title').text('Crear Producto'); // Set Title to Bootstrap modal title

};



function save() {

  $('#btnSave').text('guardando...'); //change button text

  $('#btnSave').attr('disabled',true); //set button disable

  var url;

  if(save_method == 'add') {

    url = "producto/ajax_add";

    msgsuccess = "El registro fue creado exitosamente.";

    msgerror = "El registro no se pudo crear verifique las validaciones.";

  } else {

    url = "producto/ajax_update";

    msgsuccess = "El registro fue actualizado exitosamente.";

    msgerror = "El registro no se pudo actualizar. Verifique la operación";

  }

  // ajax adding data to database

  $.ajax({

    url : url,

    type: "POST",

    data: $('#form').serialize(),

    dataType: "JSON",

    success: function(data) {

      //if success close modal and reload ajax table

      if(data.status) {

          $('#modal_form').modal('hide');

          reload_table();

          Lobibox.notify('success', {

            size: 'mini',

            msg: msgsuccess

          });

      } else {

        for (var i = 0; i < data.inputerror.length; i++) {

          $('[name="'+data.inputerror[i]+'"]').parent().parent().addClass('has-error'); //select parent twice to select div form-group class and add has-error class

          $('[name="'+data.inputerror[i]+'"]').next().text(data.error_string[i]); //select span help-block class set text error string

        }

      }

      $('#btnSave').text('Guardar'); //change button text

      $('#btnSave').attr('disabled',false); //set button enable

    },

    error: function (jqXHR, textStatus, errorThrown) {

      Lobibox.notify('error', {

        size: 'mini',

        msg: msgerror

      });

      $('#btnSave').text('Guardar'); //change button text

      $('#btnSave').attr('disabled',false); //set button enable

    }

  });

};



function reload_table() {

  table.ajax.reload(null,false); //reload datatable ajax

};



function edit(id) {

  save_method = 'update';

  $('#marcas').hide();

  $('#familias').hide();

  $('#codigoexternos').hide();

  $('#minimos').hide();

  $('#preciocompras').hide();

  $('#form')[0].reset(); // reset form on modals

  $('.form-group').removeClass('has-error'); // clear error class

  $('.help-block').empty(); // clear error string

  //Ajax Load data from ajax

  $.ajax({

    url : "producto/ajax_edit/" + id,

    type: "GET",

    dataType: "JSON",

    success: function(data) {

      if(data.categoria == '0') {

        $('#marcas').show();

        $('#familias').show();

        $('#codigoexternos').show();

        $('#minimos').show();

        $('#preciocompras').show();

      }

      $('[name="id"]').val(data.id);

      $('[name="categoria"]').val(data.categoria);

      $('[name="marca"]').val(data.marca);

      $('[name="familia"]').val(data.familia);

      $('[name="codigo"]').val(data.codigo);

      $('[name="numero"]').val(data.numero);

      $('[name="unidad"]').val(data.unidad);

      $('[name="codigoexterno"]').val(data.codigoexterno);

      $('[name="nombre"]').val(data.nombre);

      $('[name="minimo"]').val(data.minimo);

      $('[name="preciocompra"]').val(data.preciocompra);

      $('[name="precioventa"]').val(data.precioventa);

      $('[name="preciodistribuidor"]').val(data.preciodistribuidor);

      $('[name="preciomayorista"]').val(data.preciomayorista);

      $('[name="unidad"]').val(data.unidad);

      $('#modal_form').modal('show'); // show bootstrap modal when complete loaded

      $('.modal-title').text('Modificar Producto'); // Set title to Bootstrap modal title

    },

    error: function (jqXHR, textStatus, errorThrown) {

      Lobibox.notify('error', {

        size: 'mini',

        msg: 'Error al obtener datos de ajax.'

      });

    }

  });

};



function detalle(id) {

  //Ajax Load data from ajax

  $.ajax({

    url : "producto/ajax_detalle/" + id,

    type: "GET",

    dataType: "JSON",

    success: function(data) {

      $('[name="codigoexterno"]').val(data.codigoexterno);

      $('[name="nombre"]').val(data.nombre);

      $('[name="minimo"]').val(data.minimo);

      $('[name="preciocompra"]').val(data.preciocompra);

      $('[name="precioventa"]').val(data.precioventa);

      $('[name="preciodistribuidor"]').val(data.preciodistribuidor);

      $('[name="preciomayorista"]').val(data.preciomayorista);

      $('[name="unidad"]').val(data.unidad);

      $('#detalle_form').modal('show'); // show bootstrap modal when complete loaded

      $('.modal-title').text('Detalle del Producto'); // Set title to Bootstrap modal title

    },

    error: function (jqXHR, textStatus, errorThrown) {

      Lobibox.notify('error', {

        size: 'mini',

        msg: 'Error al obtener datos de ajax.'

      });

    }

  });

};



function borrar(id) {

  bootbox.confirm("Seguro desea Eliminar este registro?", function(result) {

    if (result === true) {

      $.ajax({

        url : "producto/ajax_delete/"+id,

        type: "POST",

        dataType: "JSON",

        success: function(data) {

          //if success reload ajax table

          $('#modal_form').modal('hide');

          reload_table();

          Lobibox.notify('success', {

            size: 'mini',

            msg: 'El registro fue eliminado exitosamente.'

          });

        },

        error: function (jqXHR, textStatus, errorThrown) {

          Lobibox.notify('error', {

            size: 'mini',

            msg: 'No se puede eliminar este registro por seguridad de su base de datos, Contacte al Administrador del Sistema'

          });

        }

      });

    }

  });

};



function desactivar(id) {

  bootbox.confirm("Seguro desea desactivar este registro?", function(result) {

    if (result === true) {

      $.ajax({

        url : "producto/ajax_desactivar/"+id,

        type: "POST",

        dataType: "JSON",

        success: function(data) {

          //if success reload ajax table

          $('#modal_form').modal('hide');

          reload_table();

          Lobibox.notify('success', {

            size: 'mini',

            msg: 'El registro fue desactivado exitosamente.'

          });

        },

        error: function (jqXHR, textStatus, errorThrown) {

          Lobibox.notify('error', {

            size: 'mini',

            msg: 'No se puede desactivar este registro por seguridad de su base de datos, Contacte al Administrador del Sistema'

          });

        }

      });

    }

  });

};



function activar(id) {

  bootbox.confirm("Seguro desea activar este registro?", function(result) {

    if (result === true) {

      $.ajax({

        url : "producto/ajax_activar/"+id,

        type: "POST",

        dataType: "JSON",

        success: function(data) {

          //if success reload ajax table

          $('#modal_form').modal('hide');

          reload_table();

          Lobibox.notify('success', {

            size: 'mini',

            msg: 'El registro fue activado exitosamente.'

          });

        },

        error: function (jqXHR, textStatus, errorThrown) {

          Lobibox.notify('error', {

            size: 'mini',

            msg: 'No se puede activar este registro por seguridad de su base de datos, Contacte al Administrador del Sistema'

          });

        }

      });

    }

  });

};



function combo(combo) {

  save_method = 'addcombo';

  $('#form_combo')[0].reset(); // reset form on

  $('#combo').val(combo);

  $('#btnSaveCombo').text('GRABAR');

  $('.form-group').removeClass('has-error'); // clear error class

  $('.help-block').empty(); // clear error string

  $('#combo_form').modal('show'); // show bootstrap modal

  $('.modal-title').text('Crear Combinacion'); // Set Title to Bootstrap modal title

  cargar_combos(combo);

};



function cargar_combos(combo) {

  tables = $('#tabla_combo').DataTable({

    language: {

        "decimal": "",

        "emptyTable": "No hay información",

        "info": "Mostrando _START_ a _END_ de _TOTAL_ Entradas",

        "infoEmpty": "Mostrando 0 to 0 of 0 Entradas",

        "infoFiltered": "(Filtrado de _MAX_ total entradas)",

        "infoPostFix": "",

        "thousands": ",",

        "lengthMenu": "Mostrar _MENU_ Entradas",

        "loadingRecords": "Cargando...",

        "processing": "Procesando...",

        "search": "Buscar:",

        "zeroRecords": "Sin resultados encontrados",

        "paginate": {

            "first": "Primero",

            "last": "Ultimo",

            "next": "Siguiente",

            "previous": "Anterior"

        }

    },

    "destroy": true,

    //Feature control the processing indicator.

    "processing": true,

    //Feature control DataTables' server-side processing mode.

    "serverSide": true,

    //Initial no order.

    "order": [],

    // Load data for the table's content from an Ajax source

    "ajax": {

      "url": "producto/ajax_list_combo/"+combo,

      "type": "POST"

    },

    //Set column definition initialisation properties.

    "columnDefs": [{

      //last column

      "targets": [-1],

      //set not orderable

      "orderable": true,

    }],

  });

};



function savecombo() {

  $('#btnSaveCombo').text('guardando...'); //change button text

  $('#btnSaveCombo').attr('disabled',true); //set button disable

  // ajax adding data to database

  $.ajax({

    url : 'producto/ajax_addcombo',

    type: "POST",

    data: $('#form_combo').serialize(),

    dataType: "JSON",

    success: function(data) {

      //if success close modal and reload ajax table

      if(data.status) {

          reload_tables();

          $('#form_combo')[0].reset();

          Lobibox.notify('success', {

            size: 'mini',

            msg: 'El registro fue creado exitosamente.'

          });

          $('#btnSaveCombo').text('GRABAR'); //change button text

          $('#btnSaveCombo').attr('disabled',false); //set button enable

      } else {

        for (var i = 0; i < data.inputerror.length; i++) {

          $('[name="'+data.inputerror[i]+'"]').parent().parent().addClass('has-error'); //select parent twice to select div form-group class and add has-error class

          $('[name="'+data.inputerror[i]+'"]').next().text(data.error_string[i]); //select span help-block class set text error string

        }

        $('#btnSaveCombo').text('GRABAR'); //change button text

        $('#btnSaveCombo').attr('disabled',false); //set button enable

      }

    },

    error: function (jqXHR, textStatus, errorThrown) {

      Lobibox.notify('error', {

        size: 'mini',

        msg: 'El registro no se pudo crear verifique las validaciones.'

      });

      $('#btnSaveCombo').text('GRABAR'); //change button text

      $('#btnSaveCombo').attr('disabled',false); //set button enable

    }

  });

};



function borrarcombo(id) {

  bootbox.confirm("Seguro desea Eliminar este registro?", function(result) {

    if (result === true) {

      $.ajax({

        url : "producto/ajax_deletecombo/"+id,

        type: "POST",

        dataType: "JSON",

        success: function(data) {

          //if success reload ajax table

          reload_tables();

          Lobibox.notify('success', {

            size: 'mini',

            msg: 'El registro fue eliminado exitosamente.'

          });

        },

        error: function (jqXHR, textStatus, errorThrown) {

          Lobibox.notify('error', {

            size: 'mini',

            msg: 'No se puede eliminar este registro por seguridad de su base de datos, Contacte al Administrador del Sistema'

          });

        }

      });

    }

  });

};



function reload_tables() {

  tables.ajax.reload(null,false); //reload datatable ajax

};

