<div class="row">

  <div class="col-lg-12">

    <div class="card card-border">

      <div class="card-header bg-transparent pb-0">

        <div class="card-widgets">

          <button type="button" class="btn btn-primary btn-xs" onclick="location.reload()"><i class="fa fa-redo"></i> Recargar</button>

          <button type="button" class="btn btn-danger btn-xs" onclick="add()"><i class="fa fa-plus"></i> Nuevo</button>

        </div>

        <h3 class="card-title text-dark">Lista de <?= $this->titulo_controlador ?></h3>

      </div>

      <!-- /.box-header -->

      <div class="card-body table-responsive">

        <table id="tabla" class="table table-sm table-striped table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">

          <thead>

            <tr class="bg-primary text-white">

              <th>#</th>

              <th>DNI</th>

              <th>Nombre</th>

              <th>Usuario</th>

              <th>Perfil</th>

              <th>Estado</th>

              <th>Acciones</th>

            </tr>

          </thead>

          <tbody></tbody>

        </table>

      </div>

    </div>

  </div>

</div>



<!-- Bootstrap modal -->

<div id="modal_form" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">

  <div class="modal-dialog modal-lg">

    <div class="modal-content">

      <div class="modal-header">

        <h3 class="modal-title"></h3>

        <button type="button" class="close" data-dismiss="modal" aria-label="Close">

          <span aria-hidden="true">&times;</span>

        </button>

      </div>

      <div class="modal-body">

        <form action="#" id="form" class="" autocomplete="off">

          <div class="row">

            <input class="form-control" type="hidden" id="id" name="id">

            <div class="col-md-6">

              <div class="form-group">

                <!-- <label class="control-label">Nro de documento<i class="icon fa fa-exclamation-circle text-danger fa-fw" title="Obligatorio" aria-label="Obligatorio"></i></label>

                <input class="form-control" id="documento" type="text" name="documento" maxlength="8">

                <span class="help-block"></span> -->

                <label>Nro de Documento<span class="required">*</span></label>

                <div class="input-group">

                  <input type="number" id="documento" name="documento" class="form-control" placeholder="Nro de Documento">

                  <span class="help-block"></span>

                  <span class="input-group-append">

                    <button type="button" class="btn waves-effect waves-light btn-primary" onclick="buscardni();" id="btnbuscardni">

                      <i class="fa fa-search"></i>

                    </button>

                  </span>

                </div>

              </div>

              <div class="form-group">

                <label class="control-label">Nacionalidad</label>

                <select id="nacionalidad" name="nacionalidad" class="form-control">

                  <option value="">SELECCIONAR</option>

                  <option value="0">PERUANA</option>

                  <option value="1">EXTRANJERA</option>

                </select>

                <span class="help-block"></span>

              </div>

              <div class="form-group">

                <label class="control-label">Nombres<i class="icon fa fa-exclamation-circle text-danger fa-fw" title="Obligatorio" aria-label="Obligatorio"></i></label>

                <input class="form-control" id="nombre" type="text" name="nombre">

                <span class="help-block"></span>

              </div>

              <div class="form-group">

                <label class="control-label">Apellidos<i class="icon fa fa-exclamation-circle text-danger fa-fw" title="Obligatorio" aria-label="Obligatorio"></i></label>

                <input class="form-control" id="apellido" type="text" name="apellido">

                <span class="help-block"></span>

              </div>

              <div class="form-group">

                <label class="control-label">sexo<i class="icon fa fa-exclamation-circle text-danger fa-fw" title="Obligatorio" aria-label="Obligatorio"></i></label>

                <select id="sexo" name="sexo" class="form-control">

                  <option value="">SELECCIONAR</option>

                  <option value="0">MASCULINO</option>

                  <option value="1">FEMENINO</option>

                </select>

                <span class="help-block"></span>

              </div>

              <? if ($perfil == null) { ?>

                <div class="form-group">

                  <label class="control-label">Fecha nacimiento</label>

                  <input class="form-control" id="nacimiento" type="date" name="nacimiento">

                  <span class="help-block"></span>

                </div>

              <? } ?>



            </div>

            <div class="col-md-6">

              <? if ($perfil != null) { ?>

                <div class="form-group">

                  <label class="control-label">Fecha nacimiento</label>

                  <input class="form-control" id="nacimiento" type="date" name="nacimiento">

                  <span class="help-block"></span>

                </div>

              <? } ?>

              <div class="form-group">

                <label class="control-label">Celular</label>

                <input class="form-control" id="celular" type="text" name="celular">

                <span class="help-block"></span>

              </div>

              <div class="form-group">

                <label class="control-label">Direccion</label>

                <input class="form-control" id="direccion" type="text" name="direccion" onkeyup="this.value=this.value.toUpperCase()">

                <span class="help-block"></span>

              </div>

              <div class="form-group">

                <label class="control-label">Correo electronico</label>

                <input class="form-control" id="correo" type="email" name="correo">

                <span class="help-block"></span>

              </div>

              <? if ($perfil == 4) { ?>

                <div class="form-group">

                  <label class="control-label">Apoderado</label>

                  <input id="pariente" type="hidden" name="pariente">

                  <input class="form-control" id="apoderado" type="text" name="apoderado">

                  <span class="help-block"></span>

                </div>

              <? } ?>

              <? if ($perfil == null) { ?>

                <div class="form-group">

                  <label class="control-label">Usuario<i class="icon fa fa-exclamation-circle text-danger fa-fw " title="Obligatorio" aria-label="Obligatorio"></i></label>

                  <input class="form-control" id="usuario" type="text" name="usuario">

                  <span class="help-block"></span>

                </div>

                <div class="form-group">

                  <label class="control-label">Contraseña<i class="icon fa fa-exclamation-circle text-danger fa-fw" title="Obligatorio"></i></label>

                  <input class="form-control password" id="password" type="password" name="password">

                  <span class="help-block"></span>

                </div>

                <div class="form-group">

                  <label class="control-label">Perfil<i class="icon fa fa-exclamation-circle text-danger fa-fw " title="Obligatorio" aria-label="Obligatorio"></i></label>

                  <select id="perfil" name="perfil" class="form-control"></select>

                  <span class="help-block"></span>

                </div>

              <? } ?>

              <? if ($perfil == 6) { ?>

                <div class="form-group">

                  <label class="control-label">Parentesco</label>

                  <input class="form-control" id="especialidad" type="text" name="especialidad" onkeyup="this.value=this.value.toUpperCase()">

                  <span class="help-block"></span>

                </div>

              <? } ?>

            </div>

        </form>

      </div>

    </div>

    <div class="modal-footer">

      <button type="button" id="btnSave" onclick="save()" class="btn btn-primary">Guardar</button>

      <button type="button" class="btn btn-danger" data-dismiss="modal">Cerrar</button>

    </div>

  </div>

</div>

<!-- End Bootstrap modal -->



<!-- Bootstrap modal -->

<div id="hijos_form" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">

  <div class="modal-dialog modal-lg">

    <div class="modal-content">

      <div class="modal-header">

        <h3 class="modal-title"></h3>

        <button type="button" class="close" data-dismiss="modal" aria-label="Close">

          <span aria-hidden="true">&times;</span>

        </button>

      </div>

      <div class="modal-body">

        <div class="row">

          <div class="col-lg-12">

            <div class="card">

              <div class="card-header">

                <h3 class="card-title text-dark">Lista de Alumnos</h3>

              </div>

              <!-- /.box-header -->

              <div class="card-body table-responsive">

                <table id="tabla_hijos" class="table table-sm table-striped table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">

                  <thead>

                    <tr>

                      <th>#</th>

                      <th>DNI</th>

                      <th>Nombre</th>

                      <th>Grado</th>

                    </tr>

                  </thead>

                  <tbody></tbody>

                </table>

              </div>

              <!-- /.box-body -->

            </div>

          </div>

        </div>

      </div>

      <div class="modal-footer">

        <button type="button" class="btn btn-danger" data-dismiss="modal">Cerrar</button>

      </div>

    </div><!-- /.modal-content -->

  </div><!-- /.modal-dialog -->

</div><!-- /.modal -->



<script type="text/javascript">

  //for save method string

  var save_method;

  var table;

  $(document).ready(function() {

    cargarperfil();

    $('#documento').numeric();

    $("#nombre").mayusculassintildes();

    $("#apellido").mayusculassintildes();

    $("#apoderado").autocomplete({

      source: "<?= $this->url ?>/completarpariente",

      minLength: 2,

      select: function(event, ui) {

        $("#pariente").val(ui.item.pariente);

      }

    });

    //datatables

    table = $('#tabla').DataTable({

      language: {

        "decimal": "",

        "emptyTable": "No hay información",

        "info": "Mostrando _START_ a _END_ de _TOTAL_ Entradas",

        "infoEmpty": "Mostrando 0 to 0 of 0 Entradas",

        "infoFiltered": "(Filtrado de _MAX_ total entradas)",

        "infoPostFix": "",

        "thousands": ",",

        "lengthMenu": "Mostrar _MENU_ Entradas",

        "loadingRecords": "Cargando...",

        "processing": "Procesando...",

        "search": "Buscar:",

        "zeroRecords": "Sin resultados encontrados",

        "paginate": {

          "first": "Primero",

          "last": "Ultimo",

          "next": "Siguiente",

          "previous": "Anterior"

        }

      },

      // dom: 'Bfrtip',

      // buttons: [

      //   'copyHtml5',

      //   'excelHtml5',

      //   'csvHtml5',

      //   'pdfHtml5'

      // ],

      // Load data for the table's content from an Ajax source

      "ajax": {

        "url": "<?= $this->url ?>/ajax_list",

        "type": "POST"

      },

    });

    //set input/textarea/select event when change value, remove class error and remove text help block

    $("input").change(function() {

      $(this).parent().removeClass('has-error');

      $(this).next().empty();

    });

    $("textarea").change(function() {

      $(this).parent().removeClass('has-error');

      $(this).next().empty();

    });

    $("select").change(function() {

      $(this).parent().removeClass('has-error');

      $(this).next().empty();

    });

    $('#password').bind('blur', function() {

      if ($(this).val() !== '') {

        $('#re_password').attr('required', 'required');

      } else {

        $('.re_password').removeAttr('required').valid();

      }

    });

    $('#botoncito').on('click', function() {

      var tipo = $('#tipo').val();

      var documento = $('#documento').val();

      $(this).button('loading');

      $.ajax({

        type: 'POST',

        url: "<?= $this->url ?>/consulta_reniec",

        data: {

          "tipo": tipo,

          "documento": documento

        },

        success: function(data) {

          $('#botoncito').button('reset');

          document.getElementById('nombre').value = data.nombre;

          document.getElementById('apellido').value = data.apellido;

          document.getElementById('direccion').value = data.direccion;

        },

        error: function(data) {

          $('#botoncito').button('reset');

          Lobibox.notify('error', {

            size: 'mini',

            msg: 'Error al obtener datos de ajax.'

          });

        }

      });

    });

  });



  function cargarperfil() {

    $.ajax({

      url: "<?= $this->url ?>/cargarperfil",

      method: "POST",

      dataType: "json",

      success: function(data) {

        $("#perfil option").remove();

        var options = '';

        $.each(data.perfiles, function(index, value) {

          options += "<option value='" + value.id + "'>" + value.nombre + "</option>"

        });

        $("#perfil").append(options);

      },

      error: function(jqXHR, textStatus, errorThrown) {

        console.log(jqXHR);

      }

    });

  };



  function capturarCorreo() {

    if ($("#id").val().length === 0) {

      var arraynombre = $.trim($("#nombre").val()).split(" ");

      var nombre = arraynombre.length > 0 ? arraynombre[0] : "";

      var correo = nombre + "." + $.trim($("#apellido").val()) + "@ingenierosuni.edu.pe";

      $("#correo").val(correo.toLowerCase());

    }

  };



  function add() {

    save_method = 'add';

    $('#form')[0].reset(); // reset form on modals

    $('.form-group').removeClass('has-error'); // clear error class

    $('.help-block').empty(); // clear error string

    $('#id').val('');

    $('#modal_form').modal('show'); // show bootstrap modal

    $('.modal-title').text('Crear Usuario'); // Set Title to Bootstrap modal title

  };



  function save() {

    $('#btnSave').text('guardando...'); //change button text

    $('#btnSave').attr('disabled', true);

    //$('#btnSave').attr('disabled',true);

    var url;

    if (save_method == 'add') {

      url = "<?= $this->url ?>/ajax_add";

      msgsuccess = "El registro fue creado exitosamente.";

      msgerror = "El registro no se pudo crear verifique las validaciones.";

    } else {

      url = "<?= $this->url ?>/ajax_update";

      msgsuccess = "El registro fue actualizado exitosamente.";

      msgerror = "El registro no se pudo actualizar. Verifique la operaciòn";

    }



    // console.log(new FormData($('#form')[0]));

    // console.log($('#form').serialize());

    // ajax adding data to database

    $.ajax({

      url: url,

      type: "POST",

      // data: new FormData($('#form')[0]),

      // dataType: "JSON",

      // contentType: false,

      // processData: false,

      data: $('#form').serialize(),

      dataType: "JSON",

      //beforeSend:function(){$('#btnSave').html('guardando...');},

      success: function(data) {

        console.log(data);

        if (data.status) {

          $('#modal_form').modal('hide');

          reload_table();

          Lobibox.notify('success', {

            size: 'mini',

            msg: msgsuccess

          });

        } else {

          for (var i = 0; i < data.inputerror.length; i++) {

            $('[name="' + data.inputerror[i] + '"]').parent().addClass('has-error');

            $('[name="' + data.inputerror[i] + '"]').next().text(data.error_string[i]);

          }

        }

        $('#btnSave').text('Guardar'); //change button text

        $('#btnSave').attr('disabled', false);

      },

      error: function(jqXHR, textStatus, errorThrown) {

        Lobibox.notify('error', {

          size: 'mini',

          msg: msgerror

        });

        $('#btnSave').text('Guardar'); //change button text

        $('#btnSave').attr('disabled', false);

      }

    });

  };



  function reload_table() {

    table.ajax.reload(null, false); //reload datatable ajax

  };



  function edit(id) {

    save_method = 'update';

    $('#form')[0].reset(); // reset form on modals

    $('.form-group').removeClass('has-error'); // clear error class

    $('.help-block').empty(); // clear error string

    $('#btnsaveimg').hide();

    //Ajax Load data from ajax

    $.ajax({

      url: "<?= $this->url ?>/ajax_edit/" + id,

      type: "GET",

      dataType: "JSON",

      success: function(data) {

        $('[name="id"]').val(data.id);

        $('[name="usuario"]').val(data.usuario);

        $('[name="nombre"]').val(data.nombre);

        $('[name="apellido"]').val(data.apellido);

        $('[name="documento"]').val(data.documento);

        $('[name="direccion"]').val(data.direccion);

        $('[name="celular"]').val(data.celular);

        $('[name="correo"]').val(data.correo);

        $('[name="nacimiento"]').val(data.nacimiento);

        $('[name="sexo"]').val(data.sexo);

        $('[name="perfil"]').val(data.perfil);

        $('[name="nacionalidad"]').val(data.nacionalidad);

        $('[name="password"]').attr("placeholder", "*****");

        $('#modal_form').modal('show'); // show bootstrap modal when complete loaded

        $('.modal-title').text('Modificar Usuario'); // Set title to Bootstrap modal title

      },

      error: function(jqXHR, textStatus, errorThrown) {

        Lobibox.notify('error', {

          size: 'mini',

          msg: 'Error al obtener datos de ajax.'

        });

      }

    });

  };



  function borrar(id) {

    bootbox.confirm("Seguro desea Eliminar este registro?", function(result) {

      if (result === true) {

        $.ajax({

          url: "<?= $this->url ?>/ajax_delete/" + id,

          type: "POST",

          dataType: "JSON",

          success: function(data) {

            //if success reload ajax table

            $('#modal_form').modal('hide');

            reload_table();

            Lobibox.notify('success', {

              size: 'mini',

              msg: 'El registro fue eliminado exitosamente.'

            });

          },

          error: function(jqXHR, textStatus, errorThrown) {

            Lobibox.notify('error', {

              size: 'mini',

              msg: 'No se puede eliminar este registro por seguridad de su base de datos, Contacte al Administrador del Sistema'

            });

          }

        });

      }

    });

  };



  function desactivar(id) {

    bootbox.confirm("Seguro desea desactivar este registro?", function(result) {

      if (result === true) {

        $.ajax({

          url: "<?= $this->url ?>/ajax_desactivar/" + id,

          type: "POST",

          dataType: "JSON",

          success: function(data) {

            //if success reload ajax table

            $('#modal_form').modal('hide');

            reload_table();

            Lobibox.notify('success', {

              size: 'mini',

              msg: 'El registro fue desactivado exitosamente.'

            });

          },

          error: function(jqXHR, textStatus, errorThrown) {

            Lobibox.notify('error', {

              size: 'mini',

              msg: 'No se puede desactivar este registro por seguridad de su base de datos, Contacte al Administrador del Sistema'

            });

          }

        });

      }

    });

  };



  function activar(id) {

    bootbox.confirm("Seguro desea activar este registro?", function(result) {

      if (result === true) {

        $.ajax({

          url: "<?= $this->url ?>/ajax_activar/" + id,

          type: "POST",

          dataType: "JSON",

          success: function(data) {

            //if success reload ajax table

            $('#modal_form').modal('hide');

            reload_table();

            Lobibox.notify('success', {

              size: 'mini',

              msg: 'El registro fue activado exitosamente.'

            });

          },

          error: function(jqXHR, textStatus, errorThrown) {

            Lobibox.notify('error', {

              size: 'mini',

              msg: 'No se puede activar este registro por seguridad de su base de datos, Contacte al Administrador del Sistema'

            });

          }

        });

      }

    });

  };



  function hijos(pariente) {

    save_method = 'addhijo';

    // $('#form_hijo')[0].reset(); // reset form on

    $('#pariente').val(pariente);

    $('#btnSaveCombo').text('GRABAR');

    $('.form-group').removeClass('has-error'); // clear error class

    $('.help-block').empty(); // clear error string

    $('#hijos_form').modal('show'); // show bootstrap modal

    $('.modal-title').text('Alumnos selecionados'); // Set Title to Bootstrap modal title

    cargar_hijos(pariente);

  };



  function cargar_hijos(pariente) {

    tables = $('#tabla_hijos').DataTable({

      language: {

        "decimal": "",

        "emptyTable": "No hay información",

        "info": "Mostrando _START_ a _END_ de _TOTAL_ Entradas",

        "infoEmpty": "Mostrando 0 to 0 of 0 Entradas",

        "infoFiltered": "(Filtrado de _MAX_ total entradas)",

        "infoPostFix": "",

        "thousands": ",",

        "lengthMenu": "Mostrar _MENU_ Entradas",

        "loadingRecords": "Cargando...",

        "processing": "Procesando...",

        "search": "Buscar:",

        "zeroRecords": "Sin resultados encontrados",

        "paginate": {

          "first": "Primero",

          "last": "Ultimo",

          "next": "Siguiente",

          "previous": "Anterior"

        }

      },

      "destroy": true,

      "processing": true,

      "ajax": {

        url: "<?= $this->url ?>/ajax_list_hijos/" + pariente,

        type: 'GET'

      },

    });

  };



  function buscardni() {

    var api_token = "41ad0f3f2505d2f9b060857d62abdafdba0a1716e4e8ecde51f0327c66acb265";

    if ($('#documento').val().length == 8) {

      $('#btnbuscardni').html("<i class='fa fa-spinner fa-spin'></i>");

      $.ajax({

        url: "https://apiperu.dev/api/dni/" + $('#documento').val() + "?api_token=" + api_token,

        type: 'GET',

        beforeSend: function() {

          $('[name="nombre"]').val("");

          $('[name="apellido"]').val("");

        },

        success: function(data) {

          if (data.success) {

            $("#nombre").val(data.data.nombres);

            $("#apellido").val(data.data.apellido_paterno + " " + data.data.apellido_materno);

            //toastr.success("El registro fue creado exitosamente.", 'Mensaje');

          } else {

            alert('El DNI no existe');

            toastr.error('El DNI no existe', 'Mensaje');

          }

          $('#btnbuscardni').html('<i class="fa fa-search"></i>');

        },

        error: function(data) {

          $('#btnbuscardni').html('<i class="fa fa-search"></i>');

          toastr.error('Error en la busqueda, Contacte al Administrador del Sistema', 'Mensaje');

        }

      });

    } else {

      alert('INGRESE UN DNI DE 8 DIGITOS');

      toastr.error('INGRESE UN DNI DE 8 DIGITOS', 'Mensaje');

    }

  }

</script>