<?= $this->session->flashdata('mensaje') ?>
<div class="row" id="cuerpo_comprobante">
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title text-dark"><?= $this->titulo_controlador ?> alumno</h3>
            </div>
            <!-- /.box-header -->
            <form action="<?= $this->url ?>/cargaralumno" class="form-horizontal" method="POST" enctype="multipart/form-data" id="form_01" role="form">
                <div class="card-body">
                    <div class="form-group">
                        <div class="col-md-12 file-upload" id="alumnos">
                            <div class="file-select">
                                <div class="file-select-button" id="fileName">Elija el archivo</div>
                                <div class="file-select-name" id="noFileA">Ningún archivo elegido...</div>
                                <input type="file" name="alumno" id="alumno" accept="application/vnd.ms-excel">
                            </div>
                        </div>
                        <span class="help-block"></span>
                    </div>
                </div>
                <div class="card-footer text-center">
                    <a href="<?= $this->url ?>/downloads/alumno.xls" class="btn btn-danger btn-sm" role="button" data-toggle="tooltip" title="Descargar"><i class="fa fa-download"></i></a>
                    <button type="submit" class="btn btn-info btn-sm" data-toggle="tooltip" title="Ver Documento"><i class="fa fa-barcode"></i></button>
                </div>
                <!-- /.box-body -->
            </form>
        </div>
        <!-- /.box -->
    </div>
    <!-- /.col -->
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title text-dark"><?= $this->titulo_controlador ?> docente</h3>
            </div>
            <!-- /.box-header -->
            <form action="<?= $this->url ?>/cargardocente" class="form-horizontal" method="POST" enctype="multipart/form-data" id="form_02" role="form">
                <div class="card-body">
                    <div class="form-group">
                        <div class="col-md-12 file-upload" id="docentes">
                            <div class="file-select">
                                <div class="file-select-button" id="fileName">Elija el archivo</div>
                                <div class="file-select-name" id="noFileD">Ningún archivo elegido...</div>
                                <input type="file" name="docente" id="docente" accept="application/vnd.ms-excel" required>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer text-center">
                    <a href="<?= $this->url ?>/downloads/docente.xls" class="btn btn-danger btn-sm" role="button" data-toggle="tooltip" title="Descargar"><i class="fa fa-download"></i></a>
                    <button type="submit" class="btn btn-info btn-sm" data-toggle="tooltip" title="Ver Documento"><i class="fa fa-barcode"></i></button>
                </div>
                <!-- /.box-body -->
            </form>
        </div>
        <!-- /.box -->
    </div>
    <!-- /.col -->
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title text-dark">Copia de Seguridad</h3>
            </div>
            <!-- /.box-header -->
            <form action="<?= $this->url ?>/restaurar" class="form-horizontal" method="POST" id="form_03" role="form">
                <div class="card-body">
                    <div class="form-group">
                        <label class="control-label">Backup</label>
                        <select id="backup" name="backup" class="form-control" required>
                            <option value="" disabled="" selected="">Selecciona un punto de restauración</option>
                            <?php $ruta = $this->BACKUP_PATH; ?>
                            <?php if (is_dir($ruta)) { ?>
                                <?php if ($aux = opendir($ruta)) { ?>
                                    <?php while (($archivo = readdir($aux)) !== false) { ?>
                                        <?php if ($archivo != "." && $archivo != "..") { ?>
                                            <?php $nombrearchivo = str_replace(".sql", "", $archivo); ?>
                                            <?php $nombrearchivo = str_replace("-", ":", $nombrearchivo); ?>
                                            <?php $ruta_completa = $ruta . $archivo; ?>
                                            <?php if (is_dir($ruta_completa)) { ?>

                                            <?php } else { ?>
                                                <option value="<?= $ruta_completa ?>"><?= $nombrearchivo ?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    <?php } ?>
                                    <?php closedir($aux); ?>
                                <?php } ?>
                            <?php } else { ?>
                                No es ruta válida
                            <?php } ?>
                        </select>
                    </div>
                </div>
                <div class="card-footer text-center">
                    <a href="<?= $this->url ?>/backup" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Backup"><i class="fa fa-download"></i></a>
                    <button type="submit" class="btn btn-info btn-sm" data-toggle="tooltip" href="javascript:void(0)" title="Restaurar"><i class="fa fa-barcode"></i></button>
                    <a onclick="location.reload()" class="btn btn-primary btn-sm" data-toggle="tooltip" href="javascript:void(0)" title="RECARGAR"><i class="fa fa-redo"></i></a>
                    <a onclick="save()" class="btn btn-warning btn-sm" data-toggle="tooltip" href="javascript:void(0)" data-placement="top" title="GRABAR"><i class="fa fa-save"></i></a>
                </div>
                <!-- /.box-body -->
            </form>
        </div>
        <!-- /.box -->
    </div>
    <!-- /.col -->
</div>
<!-- /.row -->

<script type="text/javascript">
    $(document).ready(function() {
        $('#alumno').bind('change', function() {
            var filename = $("#alumno").val();
            if (/^\s*$/.test(filename)) {
                $("#alumnos").removeClass('active');
                $("#noFileA").text("Ningún archivo elegido...");
            } else {
                $("#alumnos").addClass('active');
                $("#noFileA").text(filename.replace("C:\\fakepath\\", ""));
            }
        });
        $('#docente').bind('change', function() {
            var filename = $("#docente").val();
            if (/^\s*$/.test(filename)) {
                $("#docentes").removeClass('active');
                $("#noFileD").text("Ningún archivo elegido...");
            } else {
                $("#docentes").addClass('active');
                $("#noFileD").text(filename.replace("C:\\fakepath\\", ""));
            }
        });
    });

    function save() {
        var light = $('#cuerpo_comprobante').parent();
        $(light).block({
            message: '<div class="loader"></div> <p><br />Enviando data, espera un momento!...</p>',
            overlayCSS: {
                backgroundColor: '#fff',
                opacity: 0.8,
                cursor: 'wait'
            },
            css: {
                border: 0,
                padding: 0,
                backgroundColor: 'none'
            }
        });
        // ajax adding data to database
        $.ajax({
            url: "<?= $this->url ?>/ajax_save",
            type: "POST",
            dataType: "JSON",
            success: function(data) {
                //if success close modal and reload ajax table
                if (data.status) {
                    Lobibox.notify('success', {
                        size: 'mini',
                        msg: "El registro fue actualizado exitosamente."
                    });
                } else {
                    for (var i = 0; i < data.inputerror.length; i++) {
                        $('[name="' + data.inputerror[i] + '"]').parent().parent().addClass('has-error'); //select parent twice to select div form-group class and add has-error class
                        $('[name="' + data.inputerror[i] + '"]').next().text(data.error_string[i]); //select span help-block class set text error string
                    }
                }
                $(light).unblock();
            },
            error: function(jqXHR, textStatus, errorThrown) {
                Lobibox.notify('error', {
                    size: 'mini',
                    msg: "El registro no se pudo actualizar. Verifique la operación"
                });
                $(light).unblock();
            }
        });
    };
</script>
