<?php

class Usuario_model extends CI_Model
{

    public function getAll($tabla)
    {
        return $this->db->get($tabla)->result();
    }

    public function get($id, $tabla)
    {
        return $this->db->where('id', $id)->get($tabla)->row();
    }

    public function save($tabla, $data)
    {
        $this->db->insert($tabla, $data);
        return $this->db->insert_id();
    }

    public function get_by_id($id, $tabla)
    {
        $this->db->from($tabla);
        $this->db->where('id', $id);
        return $this->db->get()->row();
    }

    public function update($where, $data, $tabla)
    {
        $this->db->update($tabla, $data, $where);
        return $this->db->affected_rows();
    }

    public function delete_by_id($id, $tabla)
    {
        return $this->db->where('id', $id)->delete($tabla);
    }

    public function eliminar($id, $tabla)
    {
        return $this->db->where('id', $id)->delete($tabla);
    }

    public function count_all($tabla)
    {
        return $this->db->from($tabla)->count_all_results();
    }

    public function desactivar_by_id($id, $tabla)
    {
        $data['estado'] = '1';
        return $this->db->where('id', $id)->update($tabla, $data);
    }

    public function activar_by_id($id, $tabla)
    {
        $data['estado'] = '0';
        return $this->db->where('id', $id)->update($tabla, $data);
    }

    public function perfil($tabla)
    {
        if ($this->input->post('password')) {
            $password = sha1($this->input->post('password'));
            $data['password'] = hash('sha256', $password);
        }
        $data['usuario'] = $this->input->post('usuario');
        $data['nombre'] = $this->input->post('nombre');
        $data['apellido'] = $this->input->post('apellido');
        $data['dni'] = $this->input->post('dni');
        $data['direccion'] = $this->input->post('direccion');
        $data['telefono'] = $this->input->post('telefono');
        return $this->db->where('id', $this->input->post('id'))->update($tabla, $data);
    }

    public function check($tabla)
    {
        $id = $this->input->post('id');
        $usuario = $this->input->post('usuario');
        $dni = $this->input->post('dni');
        if ($id) {
            $this->db->where('id !=', $id);
        }
        if ($usuario) {
            $this->db->where('usuario', $this->input->post('usuario'));
        }
        if ($dni) {
            $this->db->where('dni', $this->input->post('dni'));
        }
        $query = $this->db->get($tabla);
        return $query->result();
    }

    public function periodo()
    {
        return $this->db->where('estado', '0')->where('educacion', '0')->get('periodo')->row();
    }

    public function periodo_1($tipo_operacion, $ano)
    {
        return $this->db->where('estado', '0')
            ->where('idtipo', $tipo_operacion)
            ->where('periodo', $ano)
            ->get('periodo')->row();
    }

    public function docentecurso($curso, $periodo, $grado, $seccion)
    {
        $this->db->where('curso', $curso)->where('periodo', $periodo)->where('grado', $grado);
        return $this->db->where('seccion', $seccion)->get('docentecurso')->row();
    }

    public function cursos_docente_1($idperiodo, $idusuario, $idgrado)
    {
        if ($idgrado) {
            $query = $this->db->select(" `usuariodocente`.*,`grado`.`nombre` AS `grado_des`,`curso`.`nombre` AS `curso_des`")
                ->from("`usuariodocente`")
                ->join("`grado`", "`grado`.`id`=`usuariodocente`.`grado`", "inner")
                ->join("`curso`", "`curso`.`id`=`usuariodocente`.`curso`", "inner")
                ->where("`usuariodocente`.`usuario`", $idusuario)
                ->where("`usuariodocente`.`periodo`", $idperiodo)
                ->where("`usuariodocente`.`grado`", $idgrado)
                ->get();
        } else {
            $query = $this->db->select(" `usuariodocente`.*,`grado`.`nombre` AS `grado_des`,`curso`.`nombre` AS `curso_des`")
                ->from("`usuariodocente`")
                ->join("`grado`", "`grado`.`id`=`usuariodocente`.`grado`", "inner")
                ->join("`curso`", "`curso`.`id`=`usuariodocente`.`curso`", "inner")
                ->where("`usuariodocente`.`usuario`", $idusuario)
                ->where("`usuariodocente`.`periodo`", $idperiodo)
                ->get();
        }
        return $query->result();
    }

    public function alumnos_matricula_1($grado)
    {
        if ($grado) {
            $this->db->select("u.*");
            $this->db->from("usuario u");
            $this->db->join('matricula m', 'm.alumno = u.id');
            $this->db->where('u.perfil', '4');
            $this->db->where('u.estado', '0');
            $this->db->where('m.estado', '0');
            $this->db->where('m.periodo', '3');
            $this->db->where('m.grado', $grado);
        } else {
            $this->db->select("u.*");
            $this->db->from("usuario u");
            $this->db->join('matricula m', 'm.usuario = u.id');
            $this->db->where('u.perfil', '4');
            $this->db->where('u.estado', '0');
            $this->db->where('m.estado', '1');
        }
        return $this->db->get();
    }

    public function grados_docente_1($nivel, $usuario)
    {
        $mis_grados = $this->idgrado_docente_1($nivel, $usuario);
        if (count($mis_grados)) {
            return $this->db->select("*")->from("grado")->where_in("id", $mis_grados)->get()->result();
        } else {
            return false;
        }
    }

    public function idgrado_docente_1($nivel, $usuario)
    {
        $this->db->distinct()->select("g.id");
        $this->db->from("docentecurso dc");
        $this->db->join("grado g", "g.id = dc.grado");
        $this->db->where("dc.docente", $usuario);
        $this->db->where("dc.periodo", '3');
        $query = $this->db->get()->result();
        $grados = array();
        foreach ($query as $key => $value) {
            $grados[$key] = $value->id;
        }
        return $grados;
    }

    public function completaralumno($q)
    {
        $this->db->like('nombre', $q);
        $this->db->or_like('apellido', $q);
        $this->db->or_like('documento', $q);
        $query = $this->db->get('usuario');
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                if ($row->perfil == 4) {
                    $row_set[] = array(
                        'label' => $row->documento . ' | ' . $row->nombre . ' ' . $row->apellido,
                        'alumno' => $row->id,
                    );
                }
            }
            echo json_encode($row_set);
        }
    }

    public function completarpariente($q)
    {
        $this->db->like('nombre', $q);
        $this->db->or_like('apellido', $q);
        $this->db->or_like('documento', $q);
        $query = $this->db->get('usuario');
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                if ($row->perfil == 6) {
                    $row_set[] = array(
                        'label' => $row->documento . ' | ' . $row->nombre . ' ' . $row->apellido,
                        'pariente' => $row->id,
                    );
                }
            }
            echo json_encode($row_set);
        }
    }

    public function check_tema($nombre)
    {
        $this->db->where('nombre', $nombre);
        $query = $this->db->get('usuariotema');
        return $query->result();
    }

    public function get_periodo_tipo($idtipo)
    {
        return $this->db->where('idtipo', $idtipo)->where('estado', '0')->get('periodo')->row();
    }

    public function buscarusuario($dni, $perfil)
    {
        $query = $this->db
            ->where('documento', $dni)
            ->where('perfil', $perfil)
            ->get('usuario');
        return $query->row();
    }

    public function nivel_grado($usuario)
    {
        $this->db->select('v1.*, v3.nombre as nivel_des, v4.nombre as grado_des,v5.nombre as seccion_des,v6.id as periodo,v6.tipoperiodo as servicio');
        $this->db->from('usuario as v1');
        $this->db->join('matricula as v2', 'v2.alumno = v1.id');
        $this->db->join('grado as v4', 'v4.id = v2.grado');
        $this->db->join('nivel as v3', 'v3.id = v4.nivel');
        $this->db->join('seccion as v5', 'v5.id = v2.seccion');
        $this->db->join('periodo as v6', 'v6.id = v2.periodo');
        $this->db->where('v2.estado', '0')->where('v1.pariente', $usuario)->where('v1.perfil', '4')->where('v6.estado', '0');
        return $this->db->get()->result();
    }

    public function nrohijos($usuario)
    {
        $this->db->select('v1.id');
        $this->db->from('usuario as v1');
        $this->db->join('matricula as v2', 'v2.alumno = v1.id');
        $this->db->join('periodo as v3', 'v3.id = v2.periodo');
        $this->db->where('v3.estado', '0')->where('v1.pariente', $usuario)->where('v1.perfil', '4')->where('v2.estado', '0');
        return $this->db->get()->num_rows();
    }

    public function seccion($grado)
    {
        $grado = $this->get($grado, 'grado');
        return $this->db->where('nivel', $grado->nivel)->get('seccion')->result();
    }

    function queryvalidate($periodo, $grado, $seccion, $curso)
    {
        $this->db->where('periodo', $periodo);
        $this->db->where('grado', $grado);
        $this->db->where('seccion', $seccion);
        return $this->db->where('curso', $curso)->get('docentecurso')->row();
    }

    public function gradodocente($docente)
    {
        $this->db->select("dc.grado, dc.id");
        $this->db->where('p.estado', '0');
        $this->db->where('dc.docente', $docente);
        $this->db->from('docentecurso dc');
        $this->db->join('periodo p', 'p.id = dc.periodo');
        $this->db->group_by('dc.grado');
        $this->db->having("dc.grado > 1", null, false);
        return $this->db->get()->result();
    }

    public function getconpariente($id)
    {
        $this->db->select('u.*, p.nombre nomperfil, u.pariente');
        $this->db->from('usuario u');
        $this->db->join('perfil p', 'p.id = u.perfil');
        $this->db->where('u.id', $id);
        $usuario = $this->db->get()->row();
        $pariente = $this->get($usuario->pariente, 'usuario');
        if ($pariente) $usuario->apoderado = $pariente->apellido . ', ' . $pariente->nombre;
        return $usuario;
    }

    public function periodoactual($tipoperiodo)
    {
        return $this->db->where('tipoperiodo', $tipoperiodo)->where('estado', '0')->get('periodo')->row();
    }

    public function getallperiodo($tipoperiodo)
    {
        return $this->db->where('tipoperiodo', $tipoperiodo)->order_by('id', 'desc')->get('periodo')->result();
    }
}
